/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.logic;

import com.ibm.wala.logic.AbstractBinaryFormula;
import com.ibm.wala.logic.AbstractSemiDecisionProcedure;
import com.ibm.wala.logic.BinaryRelation;
import com.ibm.wala.logic.BooleanConstantFormula;
import com.ibm.wala.logic.DoubleConstant;
import com.ibm.wala.logic.FloatConstant;
import com.ibm.wala.logic.IFormula;
import com.ibm.wala.logic.ILogicConstants;
import com.ibm.wala.logic.IMaxTerm;
import com.ibm.wala.logic.ITerm;
import com.ibm.wala.logic.IntConstant;
import com.ibm.wala.logic.LongConstant;
import com.ibm.wala.logic.NotFormula;
import com.ibm.wala.logic.RelationFormula;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdHocSemiDecisionProcedure
extends AbstractSemiDecisionProcedure {
    private static final AdHocSemiDecisionProcedure INSTANCE = new AdHocSemiDecisionProcedure();

    public static AdHocSemiDecisionProcedure singleton() {
        return INSTANCE;
    }

    protected AdHocSemiDecisionProcedure() {
    }

    @Override
    public boolean isContradiction(IFormula f, Collection<IMaxTerm> facts) throws IllegalArgumentException {
        return this.contradiction(f, facts);
    }

    @Override
    public boolean isTautology(IFormula f, Collection<IMaxTerm> facts) throws IllegalArgumentException {
        return this.tautology(f, facts);
    }

    static IFormula normalize(IFormula f) throws IllegalArgumentException {
        if (f == null) {
            throw new IllegalArgumentException("f == null");
        }
        switch (f.getKind()) {
            case RELATION: {
                RelationFormula r = (RelationFormula)f;
                if (r.getRelation().equals(BinaryRelation.GE) || r.getRelation().equals(BinaryRelation.GT)) {
                    BinaryRelation swap = BinaryRelation.swap(r.getRelation());
                    return RelationFormula.make(swap, r.getTerms().get(1), r.getTerms().get(0));
                }
                return f;
            }
        }
        return f;
    }

    protected boolean atomicImplies(IFormula axiom, IFormula f) {
        return AdHocSemiDecisionProcedure.normalize(axiom).equals(AdHocSemiDecisionProcedure.normalize(f));
    }

    private boolean contradicts(IMaxTerm axiom, IFormula f) {
        IFormula notF = NotFormula.make(f);
        return this.atomicImplies(axiom, notF);
    }

    private boolean contradiction(IFormula f, Collection<IMaxTerm> facts) throws IllegalArgumentException {
        if (facts == null) {
            throw new IllegalArgumentException("facts == null");
        }
        for (IMaxTerm d : facts) {
            if (!this.contradicts(d, f)) continue;
            return true;
        }
        switch (f.getKind()) {
            case BINARY: {
                AbstractBinaryFormula b = (AbstractBinaryFormula)f;
                if (b.getConnective().equals((Object)ILogicConstants.BinaryConnective.AND)) {
                    if (this.contradiction(b.getF1(), facts) || this.contradiction(b.getF2(), facts)) {
                        return true;
                    }
                    IFormula not1 = NotFormula.make(b.getF1());
                    if (this.atomicImplies(b.getF2(), not1)) {
                        return true;
                    }
                    IFormula not2 = NotFormula.make(b.getF2());
                    if (!this.atomicImplies(b.getF1(), not2)) break;
                    return true;
                }
                if (!b.getConnective().equals((Object)ILogicConstants.BinaryConnective.OR) || !this.contradiction(b.getF1(), facts) || !this.contradiction(b.getF2(), facts)) break;
                return true;
            }
            case CONSTANT: {
                BooleanConstantFormula bc = (BooleanConstantFormula)f;
                return bc.equals(BooleanConstantFormula.FALSE);
            }
            case QUANTIFIED: {
                return false;
            }
            case RELATION: {
                RelationFormula r = (RelationFormula)f;
                if (r.getRelation().equals(BinaryRelation.EQUALS)) {
                    ITerm lhs = r.getTerms().get(0);
                    ITerm rhs = r.getTerms().get(1);
                    if (!lhs.getKind().equals((Object)ITerm.Kind.CONSTANT) || !rhs.getKind().equals((Object)ITerm.Kind.CONSTANT) || lhs.equals(rhs)) break;
                    return true;
                }
                if (r.getRelation().equals(BinaryRelation.NE)) {
                    ITerm rhs;
                    ITerm lhs = r.getTerms().get(0);
                    if (!lhs.equals(rhs = r.getTerms().get(1))) break;
                    return true;
                }
                if (r.getRelation().equals(BinaryRelation.LT)) {
                    ITerm lhs = r.getTerms().get(0);
                    ITerm rhs = r.getTerms().get(1);
                    if (!lhs.getKind().equals((Object)ITerm.Kind.CONSTANT) || !rhs.getKind().equals((Object)ITerm.Kind.CONSTANT) || !(lhs instanceof IntConstant) || !(rhs instanceof IntConstant)) break;
                    IntConstant c1 = (IntConstant)lhs;
                    IntConstant c2 = (IntConstant)rhs;
                    return c1.getVal().intValue() >= c2.getVal().intValue();
                }
                if (!r.getRelation().equals(BinaryRelation.LE)) break;
                ITerm lhs = r.getTerms().get(0);
                ITerm rhs = r.getTerms().get(1);
                if (!lhs.getKind().equals((Object)ITerm.Kind.CONSTANT) || !rhs.getKind().equals((Object)ITerm.Kind.CONSTANT) || !(lhs instanceof IntConstant) || !(rhs instanceof IntConstant)) break;
                IntConstant c1 = (IntConstant)lhs;
                IntConstant c2 = (IntConstant)rhs;
                return c1.getVal().intValue() > c2.getVal().intValue();
            }
        }
        return false;
    }

    private boolean tautology(IFormula f, Collection<IMaxTerm> facts) throws IllegalArgumentException {
        if (facts == null) {
            throw new IllegalArgumentException("facts == null");
        }
        for (IMaxTerm d : facts) {
            if (!this.atomicImplies(d, f)) continue;
            return true;
        }
        switch (f.getKind()) {
            case BINARY: {
                AbstractBinaryFormula b = (AbstractBinaryFormula)f;
                if (b.getConnective().equals((Object)ILogicConstants.BinaryConnective.AND) && this.tautology(b.getF1(), facts) && this.tautology(b.getF2(), facts)) {
                    return true;
                }
                if (!b.getConnective().equals((Object)ILogicConstants.BinaryConnective.OR)) break;
                if (this.tautology(b.getF1(), facts) || this.tautology(b.getF2(), facts)) {
                    return true;
                }
                if (!b.getF1().equals(AdHocSemiDecisionProcedure.normalize(NotFormula.make(b.getF2())))) break;
                return true;
            }
            case CONSTANT: {
                return f.equals(BooleanConstantFormula.TRUE);
            }
            case NEGATION: {
                NotFormula n = (NotFormula)f;
                return AdHocSemiDecisionProcedure.singleton().isContradiction(n.getFormula());
            }
            case QUANTIFIED: {
                return false;
            }
            case RELATION: {
                ITerm rhs;
                ITerm lhs;
                RelationFormula r = (RelationFormula)f;
                if (r.getRelation().equals(BinaryRelation.EQUALS)) {
                    ITerm rhs2;
                    ITerm lhs2 = r.getTerms().get(0);
                    if (!lhs2.equals(rhs2 = r.getTerms().get(1))) break;
                    return true;
                }
                if (r.getRelation().equals(BinaryRelation.NE)) {
                    ITerm lhs3 = r.getTerms().get(0);
                    ITerm rhs3 = r.getTerms().get(1);
                    if (!lhs3.getKind().equals((Object)ITerm.Kind.CONSTANT) || !rhs3.getKind().equals((Object)ITerm.Kind.CONSTANT) || lhs3.equals(rhs3)) break;
                    return true;
                }
                if (r.getRelation().equals(BinaryRelation.GE)) {
                    ITerm lhs4 = r.getTerms().get(0);
                    ITerm rhs4 = r.getTerms().get(1);
                    if (!this.isLE(rhs4, lhs4)) break;
                    return true;
                }
                if (r.getRelation().equals(BinaryRelation.LT)) {
                    ITerm lhs5 = r.getTerms().get(0);
                    ITerm rhs5 = r.getTerms().get(1);
                    if (!(lhs5 instanceof IntConstant) || !(rhs5 instanceof IntConstant)) break;
                    IntConstant x = (IntConstant)lhs5;
                    IntConstant y = (IntConstant)rhs5;
                    return x.getVal().intValue() < y.getVal().intValue();
                }
                if (!r.getRelation().equals(BinaryRelation.LE) || !this.isLE(lhs = r.getTerms().get(0), rhs = r.getTerms().get(1))) break;
                return true;
            }
        }
        return false;
    }

    public boolean isLE(ITerm a, ITerm b) {
        if (a.equals(b)) {
            return true;
        }
        if (a instanceof IntConstant && b instanceof IntConstant) {
            IntConstant ac = (IntConstant)a;
            IntConstant bc = (IntConstant)b;
            return ac.getVal().intValue() <= bc.getVal().intValue();
        }
        if (a instanceof LongConstant && b instanceof LongConstant) {
            LongConstant ac = (LongConstant)a;
            LongConstant bc = (LongConstant)b;
            return ac.getVal().longValue() <= bc.getVal().longValue();
        }
        if (a instanceof DoubleConstant && b instanceof DoubleConstant) {
            DoubleConstant ac = (DoubleConstant)a;
            DoubleConstant bc = (DoubleConstant)b;
            return ac.getVal().doubleValue() <= bc.getVal().doubleValue();
        }
        if (a instanceof FloatConstant && b instanceof FloatConstant) {
            FloatConstant ac = (FloatConstant)a;
            FloatConstant bc = (FloatConstant)b;
            return ac.getVal().floatValue() <= bc.getVal().floatValue();
        }
        return false;
    }
}

