/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.logic;

import com.ibm.wala.logic.AbstractBinaryFormula;
import com.ibm.wala.logic.AbstractVariable;
import com.ibm.wala.logic.BooleanConstantFormula;
import com.ibm.wala.logic.CNFFormula;
import com.ibm.wala.logic.DefaultDecorator;
import com.ibm.wala.logic.ICNFFormula;
import com.ibm.wala.logic.IConstant;
import com.ibm.wala.logic.IFormula;
import com.ibm.wala.logic.ILogicConstants;
import com.ibm.wala.logic.ILogicDecorator;
import com.ibm.wala.logic.IMaxTerm;
import com.ibm.wala.logic.ITerm;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryFormula
extends AbstractBinaryFormula {
    private final IFormula f1;
    private final IFormula f2;
    private final ILogicConstants.BinaryConnective b;

    private BinaryFormula(ILogicConstants.BinaryConnective b, IFormula f1, IFormula f2) {
        this.b = b;
        this.f1 = f1;
        this.f2 = f2;
    }

    public static IFormula and(Collection<IFormula> clauses) throws IllegalArgumentException {
        if (clauses == null) {
            throw new IllegalArgumentException("clauses is null");
        }
        if (clauses.isEmpty()) {
            throw new IllegalArgumentException("cannot and empty collection");
        }
        Iterator<IFormula> it = clauses.iterator();
        IFormula result = it.next();
        while (it.hasNext()) {
            result = BinaryFormula.and(result, it.next());
        }
        return result;
    }

    public static IFormula and(IFormula f1, IFormula f2) throws IllegalArgumentException {
        if (f1 == null) {
            throw new IllegalArgumentException("f1 == null");
        }
        if (f1.equals(BooleanConstantFormula.TRUE)) {
            return f2;
        }
        if (f2.equals(BooleanConstantFormula.TRUE)) {
            return f1;
        }
        if (f1.equals(BooleanConstantFormula.FALSE) || f2.equals(BooleanConstantFormula.FALSE)) {
            return BooleanConstantFormula.FALSE;
        }
        if (f1 instanceof IMaxTerm && f2 instanceof IMaxTerm) {
            ArrayList<IMaxTerm> c = new ArrayList<IMaxTerm>(2);
            c.add((IMaxTerm)f1);
            c.add((IMaxTerm)f2);
            return CNFFormula.make(c);
        }
        if (f1 instanceof ICNFFormula && f2 instanceof IMaxTerm) {
            return CNFFormula.make((ICNFFormula)f1, (IMaxTerm)f2);
        }
        if (f1 instanceof IMaxTerm && f2 instanceof ICNFFormula) {
            return CNFFormula.make((ICNFFormula)f2, (IMaxTerm)f1);
        }
        if (f1 instanceof ICNFFormula && f2 instanceof ICNFFormula) {
            return CNFFormula.make((ICNFFormula)f1, (ICNFFormula)f2);
        }
        return new BinaryFormula(ILogicConstants.BinaryConnective.AND, f1, f2);
    }

    public static BinaryFormula biconditional(IFormula f1, IFormula f2) {
        return new BinaryFormula(ILogicConstants.BinaryConnective.BICONDITIONAL, f1, f2);
    }

    public static IFormula make(ILogicConstants.BinaryConnective connective, IFormula f1, IFormula f2) {
        if (connective.equals((Object)ILogicConstants.BinaryConnective.AND)) {
            return BinaryFormula.and(f1, f2);
        }
        return new BinaryFormula(connective, f1, f2);
    }

    public static IFormula or(IFormula f1, IFormula f2) throws IllegalArgumentException {
        if (f1 == null) {
            throw new IllegalArgumentException("f1 == null");
        }
        if (f1.equals(BooleanConstantFormula.FALSE)) {
            return f2;
        }
        if (f2.equals(BooleanConstantFormula.FALSE)) {
            return f1;
        }
        if (f1.equals(BooleanConstantFormula.TRUE) || f2.equals(BooleanConstantFormula.TRUE)) {
            return BooleanConstantFormula.TRUE;
        }
        return new BinaryFormula(ILogicConstants.BinaryConnective.OR, f1, f2);
    }

    public static BinaryFormula implies(IFormula f1, IFormula f2) {
        return new BinaryFormula(ILogicConstants.BinaryConnective.IMPLIES, f1, f2);
    }

    @Override
    public ILogicConstants.BinaryConnective getConnective() {
        return this.b;
    }

    @Override
    public IFormula getF1() {
        return this.f1;
    }

    @Override
    public IFormula getF2() {
        return this.f2;
    }

    @Override
    public Collection<AbstractVariable> getFreeVariables() {
        Collection result = HashSetFactory.make();
        result.addAll(this.f1.getFreeVariables());
        result.addAll(this.f2.getFreeVariables());
        return result;
    }

    @Override
    public Collection<? extends ITerm> getAllTerms() {
        Collection result = HashSetFactory.make();
        result.addAll(this.f1.getAllTerms());
        result.addAll(this.f2.getAllTerms());
        return result;
    }

    public Collection<IConstant> getConstants() {
        Collection result = HashSetFactory.make();
        result.addAll(this.f1.getConstants());
        result.addAll(this.f2.getConstants());
        return result;
    }

    @Override
    public String prettyPrint(ILogicDecorator d) throws IllegalArgumentException {
        if (d == null) {
            throw new IllegalArgumentException("d == null");
        }
        return d.prettyPrint(this);
    }

    public String toString() {
        return this.prettyPrint(DefaultDecorator.instance());
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.b == null ? 0 : this.b.hashCode());
        result = 31 * result + (this.f1 == null ? 0 : this.f1.hashCode());
        result = 31 * result + (this.f2 == null ? 0 : this.f2.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BinaryFormula other = (BinaryFormula)obj;
        if (this.b == null ? other.b != null : !this.b.equals((Object)other.b)) {
            return false;
        }
        if (this.f1 == null ? other.f1 != null : !this.f1.equals(other.f1)) {
            return false;
        }
        return !(this.f2 == null ? other.f2 != null : !this.f2.equals(other.f2));
    }
}

