/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.logic;

import com.ibm.wala.logic.IRelation;
import com.ibm.wala.util.collections.HashMapFactory;
import java.util.Map;

public class BinaryRelation
implements IRelation {
    public static final BinaryRelation EQUALS = new BinaryRelation("=");
    public static final BinaryRelation NE = new BinaryRelation("/=");
    public static final BinaryRelation LT = new BinaryRelation("<");
    public static final BinaryRelation LE = new BinaryRelation("<=");
    public static final BinaryRelation GT = new BinaryRelation(">");
    public static final BinaryRelation GE = new BinaryRelation(">=");
    private static final Map<BinaryRelation, BinaryRelation> negations = HashMapFactory.make();
    private static final Map<BinaryRelation, BinaryRelation> swap;
    private final String symbol;

    static {
        negations.put(EQUALS, NE);
        negations.put(NE, EQUALS);
        negations.put(LT, GE);
        negations.put(GE, LT);
        negations.put(GT, LE);
        negations.put(LE, GT);
        swap = HashMapFactory.make();
        swap.put(LT, GT);
        swap.put(GE, LE);
        swap.put(GT, LT);
        swap.put(LE, GE);
    }

    protected BinaryRelation(String symbol) {
        this.symbol = symbol;
    }

    public int getValence() {
        return 2;
    }

    public String toString() {
        return String.valueOf(this.getSymbol()) + " : int x int";
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.symbol == null ? 0 : this.symbol.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BinaryRelation other = (BinaryRelation)obj;
        return !(this.symbol == null ? other.symbol != null : !this.symbol.equals(other.symbol));
    }

    public String getSymbol() {
        return this.symbol;
    }

    public static BinaryRelation make(String symbol) {
        return new BinaryRelation(symbol);
    }

    public static BinaryRelation negate(IRelation relation) {
        return negations.get(relation);
    }

    public static BinaryRelation swap(IRelation relation) {
        return swap.get(relation);
    }
}

