/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.logic;

import com.ibm.wala.logic.AbstractBinaryFormula;
import com.ibm.wala.logic.AbstractVariable;
import com.ibm.wala.logic.AdHocSemiDecisionProcedure;
import com.ibm.wala.logic.BinaryFormula;
import com.ibm.wala.logic.BinaryRelation;
import com.ibm.wala.logic.BooleanConstant;
import com.ibm.wala.logic.BooleanConstantFormula;
import com.ibm.wala.logic.DefaultDecorator;
import com.ibm.wala.logic.Disjunction;
import com.ibm.wala.logic.ICNFFormula;
import com.ibm.wala.logic.IConstant;
import com.ibm.wala.logic.IFormula;
import com.ibm.wala.logic.ILogicConstants;
import com.ibm.wala.logic.ILogicDecorator;
import com.ibm.wala.logic.IMaxTerm;
import com.ibm.wala.logic.ITerm;
import com.ibm.wala.logic.NotFormula;
import com.ibm.wala.logic.NotFormulaMaxTerm;
import com.ibm.wala.logic.RelationFormula;
import com.ibm.wala.logic.Simplifier;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CNFFormula
extends AbstractBinaryFormula
implements ICNFFormula {
    private static final boolean DEBUG = false;
    final Collection<? extends IMaxTerm> maxTerms;

    private CNFFormula(Collection<? extends IMaxTerm> maxTerms) {
        assert (maxTerms.size() >= 2);
        this.maxTerms = maxTerms;
    }

    private CNFFormula(IMaxTerm single) {
        this.maxTerms = Collections.singleton(single);
    }

    @Override
    public Collection<? extends IConstant> getConstants() {
        Collection result = HashSetFactory.make();
        for (IFormula iFormula : this.maxTerms) {
            result.addAll(iFormula.getConstants());
        }
        return result;
    }

    @Override
    public Collection<? extends ITerm> getAllTerms() {
        Collection result = HashSetFactory.make();
        for (IFormula iFormula : this.maxTerms) {
            result.addAll(iFormula.getAllTerms());
        }
        return result;
    }

    @Override
    public Collection<AbstractVariable> getFreeVariables() {
        Collection result = HashSetFactory.make();
        for (IFormula iFormula : this.maxTerms) {
            result.addAll(iFormula.getFreeVariables());
        }
        return result;
    }

    @Override
    public String prettyPrint(ILogicDecorator d) throws IllegalArgumentException {
        if (d == null) {
            throw new IllegalArgumentException("d == null");
        }
        return d.prettyPrint(this);
    }

    public static ICNFFormula make(IFormula f) throws IllegalArgumentException {
        if (f == null) {
            throw new IllegalArgumentException("f == null");
        }
        if (f instanceof ICNFFormula) {
            return (ICNFFormula)f;
        }
        switch (f.getKind()) {
            case RELATION: 
            case QUANTIFIED: 
            case CONSTANT: {
                return (IMaxTerm)f;
            }
            case NEGATION: 
            case BINARY: {
                f = CNFFormula.trivialCleanup(f);
                f = CNFFormula.eliminateArrows(f);
                f = CNFFormula.pushNegations(f);
                f = CNFFormula.distribute(f);
                if (f instanceof AbstractBinaryFormula || f instanceof NotFormula) {
                    Collection<IMaxTerm> c = CNFFormula.collectMaxTerms(f);
                    c.remove(BooleanConstantFormula.TRUE);
                    return CNFFormula.make(c);
                }
                return CNFFormula.make(f);
            }
        }
        Assertions.UNREACHABLE(f + " " + (Object)((Object)f.getKind()));
        return null;
    }

    private static Collection<IMaxTerm> collectMaxTerms(IFormula f) {
        switch (f.getKind()) {
            case RELATION: 
            case QUANTIFIED: 
            case CONSTANT: {
                return Collections.singleton((IMaxTerm)f);
            }
            case BINARY: {
                AbstractBinaryFormula b = (AbstractBinaryFormula)f;
                if (b.getConnective().equals((Object)ILogicConstants.BinaryConnective.AND)) {
                    Collection result = HashSetFactory.make();
                    result.addAll(CNFFormula.collectMaxTerms(b.getF1()));
                    result.addAll(CNFFormula.collectMaxTerms(b.getF2()));
                    return result;
                }
                if (b.getConnective().equals((Object)ILogicConstants.BinaryConnective.OR)) {
                    return Collections.singleton(CNFFormula.orToMaxTerm(b));
                }
                Assertions.UNREACHABLE();
                return null;
            }
            case NEGATION: {
                NotFormula n = (NotFormula)f;
                if (n.getFormula() instanceof RelationFormula) {
                    NotFormulaMaxTerm t = NotFormulaMaxTerm.make((RelationFormula)n.getFormula());
                    return Collections.singleton(t);
                }
                Assertions.UNREACHABLE(n.getFormula());
                return null;
            }
        }
        Assertions.UNREACHABLE(f);
        return null;
    }

    private static IMaxTerm orToMaxTerm(AbstractBinaryFormula b) {
        assert (b.getConnective().equals((Object)ILogicConstants.BinaryConnective.OR));
        Collection clauses = HashSetFactory.make();
        clauses.addAll(CNFFormula.collectMaxTerms(b.getF1()));
        clauses.addAll(CNFFormula.collectMaxTerms(b.getF2()));
        if (clauses.size() == 1) {
            return (IMaxTerm)clauses.iterator().next();
        }
        return Disjunction.make(clauses);
    }

    private static IFormula trivialCleanup(IFormula f) {
        if (AdHocSemiDecisionProcedure.singleton().isTautology(f)) {
            return BooleanConstantFormula.TRUE;
        }
        if (AdHocSemiDecisionProcedure.singleton().isContradiction(f)) {
            return BooleanConstantFormula.FALSE;
        }
        switch (f.getKind()) {
            case BINARY: {
                AbstractBinaryFormula b = (AbstractBinaryFormula)f;
                return BinaryFormula.make(b.getConnective(), CNFFormula.trivialCleanup(b.getF1()), CNFFormula.trivialCleanup(b.getF2()));
            }
            case RELATION: {
                RelationFormula r = (RelationFormula)f;
                if (r.getRelation().equals(BinaryRelation.NE) && r.getTerms().get(1).equals(BooleanConstant.FALSE)) {
                    return RelationFormula.makeEquals(r.getTerms().get(0), BooleanConstant.TRUE);
                }
                return f;
            }
        }
        return f;
    }

    private static IFormula distribute(IFormula f) {
        switch (f.getKind()) {
            case BINARY: {
                return CNFFormula.distribute((AbstractBinaryFormula)f);
            }
            case RELATION: 
            case NEGATION: 
            case QUANTIFIED: 
            case CONSTANT: {
                return f;
            }
        }
        Assertions.UNREACHABLE((Object)f.getKind());
        return null;
    }

    private static IFormula distribute(AbstractBinaryFormula b) {
        IFormula f1 = b.getF1();
        IFormula f2 = b.getF2();
        f1 = CNFFormula.distribute(f1);
        f2 = CNFFormula.distribute(f2);
        switch (b.getConnective()) {
            case OR: {
                if (f1 instanceof AbstractBinaryFormula && ((AbstractBinaryFormula)f1).getConnective().equals((Object)ILogicConstants.BinaryConnective.AND)) {
                    AbstractBinaryFormula c1 = (AbstractBinaryFormula)f1;
                    IFormula af = c1.getF1();
                    IFormula bf = c1.getF2();
                    IFormula x = BinaryFormula.and(BinaryFormula.or(af, f2), BinaryFormula.or(bf, f2));
                    return CNFFormula.distribute(x);
                }
                if (f2 instanceof AbstractBinaryFormula && ((AbstractBinaryFormula)f2).getConnective().equals((Object)ILogicConstants.BinaryConnective.AND)) {
                    AbstractBinaryFormula c2 = (AbstractBinaryFormula)f2;
                    IFormula bf = c2.getF1();
                    IFormula cf = c2.getF2();
                    IFormula x = BinaryFormula.and(BinaryFormula.or(f1, bf), BinaryFormula.or(f1, cf));
                    return CNFFormula.distribute(x);
                }
                return BinaryFormula.make(b.getConnective(), f1, f2);
            }
            case AND: {
                return BinaryFormula.make(b.getConnective(), f1, f2);
            }
        }
        Assertions.UNREACHABLE((Object)b.getConnective());
        return null;
    }

    private static IFormula pushNegations(IFormula f) {
        switch (f.getKind()) {
            case BINARY: {
                AbstractBinaryFormula b = (AbstractBinaryFormula)f;
                IFormula f1 = b.getF1();
                IFormula f2 = b.getF2();
                f1 = CNFFormula.pushNegations(f1);
                f2 = CNFFormula.pushNegations(f2);
                return BinaryFormula.make(b.getConnective(), f1, f2);
            }
            case RELATION: 
            case QUANTIFIED: 
            case CONSTANT: {
                return f;
            }
            case NEGATION: {
                NotFormula n = (NotFormula)f;
                return Simplifier.distributeNot(n);
            }
        }
        return null;
    }

    private static IFormula eliminateArrows(IFormula f) {
        switch (f.getKind()) {
            case BINARY: {
                AbstractBinaryFormula b = (AbstractBinaryFormula)f;
                return CNFFormula.eliminateArrows(b);
            }
            case RELATION: 
            case QUANTIFIED: 
            case CONSTANT: {
                return f;
            }
            case NEGATION: {
                NotFormula n = (NotFormula)f;
                return NotFormula.make(CNFFormula.eliminateArrows(n.getFormula()));
            }
        }
        Assertions.UNREACHABLE((Object)f.getKind());
        return null;
    }

    private static IFormula eliminateArrows(AbstractBinaryFormula b) {
        IFormula f1 = b.getF1();
        IFormula f2 = b.getF2();
        f1 = CNFFormula.eliminateArrows(f1);
        f2 = CNFFormula.eliminateArrows(f2);
        switch (b.getConnective()) {
            case BICONDITIONAL: {
                if (AdHocSemiDecisionProcedure.singleton().isTautology(f1)) {
                    return f2;
                }
                if (AdHocSemiDecisionProcedure.singleton().isContradiction(f1)) {
                    return BooleanConstantFormula.TRUE;
                }
                IFormula not1 = NotFormula.make(f1);
                IFormula not2 = NotFormula.make(f2);
                return BinaryFormula.or(BinaryFormula.and(f1, f2), BinaryFormula.and(not1, not2));
            }
            case AND: 
            case OR: {
                return BinaryFormula.make(b.getConnective(), f1, f2);
            }
            case IMPLIES: {
                return BinaryFormula.or(NotFormula.make(f1), f2);
            }
        }
        Assertions.UNREACHABLE(b);
        return null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.maxTerms == null ? 0 : this.maxTerms.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CNFFormula other = (CNFFormula)obj;
        return !(this.maxTerms == null ? other.maxTerms != null : !this.maxTerms.equals(other.maxTerms));
    }

    @Override
    public ILogicConstants.BinaryConnective getConnective() {
        return ILogicConstants.BinaryConnective.AND;
    }

    @Override
    public IFormula getF1() {
        return this.maxTerms.iterator().next();
    }

    @Override
    public IFormula getF2() {
        Collection c = HashSetFactory.make(this.maxTerms);
        c.remove(this.getF1());
        return CNFFormula.make(c);
    }

    public String toString() {
        StringBuffer result = new StringBuffer("CNF\n");
        int i = 1;
        for (IMaxTerm t : this.getMaxTerms()) {
            result.append(" (" + i + ") " + t.prettyPrint(DefaultDecorator.instance()) + "\n");
            ++i;
        }
        return result.toString();
    }

    public Collection<IMaxTerm> getMaxTerms() {
        return Collections.unmodifiableCollection(this.maxTerms);
    }

    public static ICNFFormula make(Collection<? extends IMaxTerm> d) {
        Collection c = HashSetFactory.make();
        for (IMaxTerm iMaxTerm : d) {
            c.add(CNFFormula.normalize(iMaxTerm));
        }
        c.remove(BooleanConstantFormula.TRUE);
        if (c.size() == 0) {
            return BooleanConstantFormula.TRUE;
        }
        if (c.size() == 1) {
            return (ICNFFormula)c.iterator().next();
        }
        return new CNFFormula(c);
    }

    public static IFormula make(ICNFFormula cnf, IMaxTerm t) {
        Collection c = HashSetFactory.make();
        c.addAll(cnf.getMaxTerms());
        c.add(t);
        return CNFFormula.make(c);
    }

    public static IFormula make(ICNFFormula f1, ICNFFormula f2) {
        Collection c = HashSetFactory.make();
        c.addAll(f1.getMaxTerms());
        c.addAll(f2.getMaxTerms());
        return CNFFormula.make(c);
    }

    public static IMaxTerm normalize(IMaxTerm f) throws IllegalArgumentException {
        if (f == null) {
            throw new IllegalArgumentException("f == null");
        }
        switch (f.getKind()) {
            case RELATION: {
                RelationFormula r = (RelationFormula)f;
                if (r.getRelation().equals(BinaryRelation.GE) || r.getRelation().equals(BinaryRelation.GT)) {
                    BinaryRelation swap = BinaryRelation.swap(r.getRelation());
                    return RelationFormula.make(swap, r.getTerms().get(1), r.getTerms().get(0));
                }
                return f;
            }
        }
        return f;
    }
}

