/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.logic;

import com.ibm.wala.logic.AbstractTheory;
import com.ibm.wala.logic.CombinedVocabulary;
import com.ibm.wala.logic.IFormula;
import com.ibm.wala.logic.ITheory;
import com.ibm.wala.logic.IVocabulary;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombinedTheory
extends AbstractTheory {
    private final ITheory a;
    private final ITheory b;

    private CombinedTheory(ITheory a, ITheory b) {
        this.a = a;
        this.b = b;
    }

    public static CombinedTheory make(ITheory a, ITheory b) throws IllegalArgumentException {
        if (a == null) {
            throw new IllegalArgumentException("a cannot be null");
        }
        if (b == null) {
            throw new IllegalArgumentException("b cannot be null");
        }
        return new CombinedTheory(a, b);
    }

    public Collection<IFormula> getSentences() {
        Set union = HashSetFactory.make();
        union.addAll(this.a.getSentences());
        union.addAll(this.b.getSentences());
        return union;
    }

    @Override
    public IVocabulary getVocabulary() {
        return CombinedVocabulary.make(this.a.getVocabulary(), this.b.getVocabulary());
    }

    public static ITheory make(ITheory t, IVocabulary<?> v) {
        return CombinedTheory.make(t, new JustVocabulary(v));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JustVocabulary
    extends AbstractTheory {
        private final IVocabulary v;

        public JustVocabulary(IVocabulary v) {
            this.v = v;
        }

        public Collection<IFormula> getSentences() {
            return Collections.emptySet();
        }

        @Override
        public IVocabulary getVocabulary() {
            return this.v;
        }
    }
}

