/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.logic;

import com.ibm.wala.logic.AbstractVariable;
import com.ibm.wala.logic.AbstractVocabulary;
import com.ibm.wala.logic.IConstant;
import com.ibm.wala.logic.IFunction;
import com.ibm.wala.logic.IRelation;
import com.ibm.wala.logic.IVocabulary;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombinedVocabulary
extends AbstractVocabulary<IConstant> {
    private final IVocabulary a;
    private final IVocabulary b;

    private CombinedVocabulary(IVocabulary a, IVocabulary b) {
        this.a = a;
        this.b = b;
        if (b.getRelations() == null) {
            throw new IllegalArgumentException("b relations are null " + b.getClass());
        }
    }

    public static CombinedVocabulary make(IVocabulary a, IVocabulary b) throws IllegalArgumentException {
        if (b == null) {
            throw new IllegalArgumentException("b == null");
        }
        return new CombinedVocabulary(a, b);
    }

    @Override
    public Collection<? extends IFunction> getFunctions() {
        Collection s = HashSetFactory.make();
        s.addAll(this.a.getFunctions());
        s.addAll(this.b.getFunctions());
        return s;
    }

    @Override
    public Collection<? extends IRelation> getRelations() {
        Collection s = HashSetFactory.make();
        s.addAll(this.a.getRelations());
        s.addAll(this.b.getRelations());
        return s;
    }

    @Override
    public Collection<AbstractVariable> getVariables() {
        Collection s = HashSetFactory.make();
        s.addAll(this.a.getVariables());
        s.addAll(this.b.getVariables());
        return s;
    }

    @Override
    public Collection<IConstant> getConstants() {
        Collection ma = this.a.getConstants();
        Collection mb = this.b.getConstants();
        assert (ma != null);
        assert (mb != null);
        Collection result = HashSetFactory.make();
        result.addAll(ma);
        result.addAll(mb);
        return result;
    }
}

