/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.logic;

import com.ibm.wala.logic.AbstractBinaryFormula;
import com.ibm.wala.logic.AbstractVariable;
import com.ibm.wala.logic.AdHocSemiDecisionProcedure;
import com.ibm.wala.logic.BooleanConstantFormula;
import com.ibm.wala.logic.DefaultDecorator;
import com.ibm.wala.logic.IConstant;
import com.ibm.wala.logic.IFormula;
import com.ibm.wala.logic.ILogicConstants;
import com.ibm.wala.logic.ILogicDecorator;
import com.ibm.wala.logic.IMaxTerm;
import com.ibm.wala.logic.ITerm;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Disjunction
extends AbstractBinaryFormula
implements IMaxTerm {
    private final Collection<? extends IFormula> clauses;

    private Disjunction(Collection<? extends IFormula> clauses) {
        assert (clauses.size() >= 2);
        this.clauses = clauses;
    }

    @Override
    public Collection<? extends IConstant> getConstants() {
        Collection result = HashSetFactory.make();
        for (IFormula iFormula : this.clauses) {
            result.addAll(iFormula.getConstants());
        }
        return result;
    }

    @Override
    public Collection<? extends ITerm> getAllTerms() {
        Collection result = HashSetFactory.make();
        for (IFormula iFormula : this.clauses) {
            result.addAll(iFormula.getAllTerms());
        }
        return result;
    }

    @Override
    public Collection<AbstractVariable> getFreeVariables() {
        Collection result = HashSetFactory.make();
        for (IFormula iFormula : this.clauses) {
            result.addAll(iFormula.getFreeVariables());
        }
        return result;
    }

    @Override
    public String prettyPrint(ILogicDecorator d) {
        if (d == null) {
            throw new IllegalArgumentException("d == null");
        }
        return d.prettyPrint(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clauses == null ? 0 : this.clauses.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Disjunction other = (Disjunction)obj;
        return !(this.clauses == null ? other.clauses != null : !this.clauses.equals(other.clauses));
    }

    @Override
    public ILogicConstants.BinaryConnective getConnective() {
        return ILogicConstants.BinaryConnective.OR;
    }

    @Override
    public IFormula getF1() {
        return this.clauses.iterator().next();
    }

    @Override
    public IFormula getF2() {
        Collection c = HashSetFactory.make(this.clauses);
        c.remove(this.getF1());
        if (c.size() == 1) {
            return (IFormula)c.iterator().next();
        }
        return Disjunction.make(c);
    }

    public static IMaxTerm make(Collection<? extends IFormula> clauses) {
        assert (clauses.size() >= 2);
        Collection newClauses = HashSetFactory.make();
        for (IFormula iFormula : clauses) {
            if (iFormula instanceof Disjunction) {
                Disjunction d = (Disjunction)iFormula;
                newClauses.addAll(d.clauses);
                continue;
            }
            if (AdHocSemiDecisionProcedure.singleton().isTautology(iFormula)) {
                return BooleanConstantFormula.TRUE;
            }
            if (AdHocSemiDecisionProcedure.singleton().isContradiction(iFormula)) continue;
            newClauses.add(AdHocSemiDecisionProcedure.normalize(iFormula));
        }
        if (newClauses.isEmpty()) {
            return BooleanConstantFormula.FALSE;
        }
        if (newClauses.size() == 1) {
            IFormula iFormula = (IFormula)newClauses.iterator().next();
            assert (iFormula instanceof IMaxTerm);
            return (IMaxTerm)iFormula;
        }
        return new Disjunction(newClauses);
    }

    public Collection<? extends IFormula> getClauses() {
        return Collections.unmodifiableCollection(this.clauses);
    }

    public String toString() {
        return this.prettyPrint(DefaultDecorator.instance());
    }

    @Override
    public Collection<? extends IMaxTerm> getMaxTerms() {
        return Collections.singleton(this);
    }
}

