/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.logic;

import com.ibm.wala.logic.AbstractTerm;
import com.ibm.wala.logic.AbstractVariable;
import com.ibm.wala.logic.BinaryFunction;
import com.ibm.wala.logic.DefaultDecorator;
import com.ibm.wala.logic.IConstant;
import com.ibm.wala.logic.IFunction;
import com.ibm.wala.logic.ILogicDecorator;
import com.ibm.wala.logic.ITerm;
import com.ibm.wala.logic.IntConstant;
import com.ibm.wala.logic.NaryFunction;
import com.ibm.wala.logic.NullaryFunction;
import com.ibm.wala.logic.UnaryFunction;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionTerm
extends AbstractTerm {
    private final List<ITerm> parameters;
    private final IFunction f;

    private FunctionTerm(IFunction f, List<ITerm> parameters) throws IllegalArgumentException {
        this.f = f;
        this.parameters = parameters;
        if (f == null) {
            throw new IllegalArgumentException("f cannot be null");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("parameters cannot be null");
        }
        for (ITerm t : parameters) {
            if (t != null) continue;
            throw new IllegalArgumentException("cannot have a null parameter");
        }
    }

    @Override
    public ITerm.Kind getKind() {
        return ITerm.Kind.FUNCTION;
    }

    public String toString() {
        return this.prettyPrint(DefaultDecorator.instance());
    }

    @Override
    public String prettyPrint(ILogicDecorator d) throws IllegalArgumentException {
        if (d == null) {
            throw new IllegalArgumentException("d == null");
        }
        return d.prettyPrint(this);
    }

    public static FunctionTerm make(UnaryFunction f, int i) {
        LinkedList<ITerm> p = new LinkedList<ITerm>();
        p.add(IntConstant.make(i));
        return new FunctionTerm(f, p);
    }

    public static FunctionTerm make(BinaryFunction f, int i, int j) {
        LinkedList<ITerm> p = new LinkedList<ITerm>();
        p.add(IntConstant.make(i));
        p.add(IntConstant.make(j));
        return new FunctionTerm(f, p);
    }

    public static FunctionTerm make(IFunction f, List<ITerm> terms) {
        assert (f.getNumberOfParameters() == terms.size());
        return new FunctionTerm(f, terms);
    }

    public static FunctionTerm make(BinaryFunction f, ITerm i, int j) {
        LinkedList<ITerm> p = new LinkedList<ITerm>();
        p.add(i);
        p.add(IntConstant.make(j));
        return new FunctionTerm(f, p);
    }

    public static FunctionTerm make(BinaryFunction f, ITerm i, ITerm j) {
        LinkedList<ITerm> p = new LinkedList<ITerm>();
        p.add(i);
        p.add(j);
        return new FunctionTerm(f, p);
    }

    public static FunctionTerm make(NullaryFunction f) {
        List<ITerm> empty = Collections.emptyList();
        return new FunctionTerm(f, empty);
    }

    public static FunctionTerm make(UnaryFunction f, ITerm t) {
        LinkedList<ITerm> p = new LinkedList<ITerm>();
        p.add(t);
        return new FunctionTerm(f, p);
    }

    public IFunction getFunction() {
        return this.f;
    }

    public List<ITerm> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public Collection<AbstractVariable> getFreeVariables() {
        Collection result = HashSetFactory.make();
        for (ITerm t : this.parameters) {
            result.addAll(t.getFreeVariables());
        }
        return result;
    }

    @Override
    public Collection<? extends IConstant> getConstants() {
        Collection result = HashSetFactory.make();
        for (ITerm t : this.parameters) {
            result.addAll(t.getConstants());
        }
        return result;
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.f == null ? 0 : this.f.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionTerm other = (FunctionTerm)obj;
        if (this.f == null ? other.f != null : !this.f.equals(other.f)) {
            return false;
        }
        return !(this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters));
    }

    @Override
    public Collection<? extends ITerm> getAllTerms() {
        Collection result = HashSetFactory.make();
        result.add(this);
        for (ITerm t : this.parameters) {
            result.addAll(t.getAllTerms());
        }
        return result;
    }

    public static FunctionTerm make(NaryFunction f, ITerm t1, ITerm t2, ITerm t3) {
        ArrayList<ITerm> l = new ArrayList<ITerm>(3);
        l.add(t1);
        l.add(t2);
        l.add(t3);
        return FunctionTerm.make(f, l);
    }
}

