/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.logic;

import com.ibm.wala.logic.AbstractVariable;
import com.ibm.wala.logic.BinaryRelation;
import com.ibm.wala.logic.BooleanConstantFormula;
import com.ibm.wala.logic.DefaultDecorator;
import com.ibm.wala.logic.IConstant;
import com.ibm.wala.logic.IFormula;
import com.ibm.wala.logic.ILogicDecorator;
import com.ibm.wala.logic.ITerm;
import com.ibm.wala.logic.RelationFormula;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotFormula
implements IFormula {
    private final IFormula f;

    protected NotFormula(IFormula f) throws IllegalArgumentException {
        this.f = f;
        if (f == null) {
            throw new IllegalArgumentException("f cannot be null");
        }
    }

    public static IFormula make(IFormula f) throws IllegalArgumentException {
        if (f == null) {
            throw new IllegalArgumentException("f == null");
        }
        switch (f.getKind()) {
            case RELATION: {
                RelationFormula r = (RelationFormula)f;
                if (r.getRelation().equals(BinaryRelation.EQUALS)) {
                    return RelationFormula.make(BinaryRelation.NE, r.getTerms());
                }
                if (r.getRelation().equals(BinaryRelation.NE)) {
                    return RelationFormula.make(BinaryRelation.EQUALS, r.getTerms());
                }
                if (r.getRelation().equals(BinaryRelation.GE)) {
                    return RelationFormula.make(BinaryRelation.LT, r.getTerms());
                }
                if (r.getRelation().equals(BinaryRelation.GT)) {
                    return RelationFormula.make(BinaryRelation.LE, r.getTerms());
                }
                if (r.getRelation().equals(BinaryRelation.LE)) {
                    return RelationFormula.make(BinaryRelation.GT, r.getTerms());
                }
                if (r.getRelation().equals(BinaryRelation.LT)) {
                    return RelationFormula.make(BinaryRelation.GE, r.getTerms());
                }
                return new NotFormula(f);
            }
            case CONSTANT: {
                if (f.equals(BooleanConstantFormula.TRUE)) {
                    return BooleanConstantFormula.FALSE;
                }
                assert (f.equals(BooleanConstantFormula.FALSE));
                return BooleanConstantFormula.TRUE;
            }
            case NEGATION: {
                NotFormula n = (NotFormula)f;
                return n.getFormula();
            }
        }
        return new NotFormula(f);
    }

    @Override
    public IFormula.Kind getKind() {
        return IFormula.Kind.NEGATION;
    }

    public IFormula getFormula() {
        return this.f;
    }

    @Override
    public Collection<AbstractVariable> getFreeVariables() {
        return this.f.getFreeVariables();
    }

    @Override
    public Collection<? extends IConstant> getConstants() {
        return this.f.getConstants();
    }

    @Override
    public Collection<? extends ITerm> getAllTerms() {
        return this.f.getAllTerms();
    }

    public String toString() {
        return this.prettyPrint(DefaultDecorator.instance());
    }

    @Override
    public String prettyPrint(ILogicDecorator d) throws IllegalArgumentException {
        if (d == null) {
            throw new IllegalArgumentException("d == null");
        }
        return d.prettyPrint(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.f == null ? 0 : this.f.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NotFormula other = (NotFormula)obj;
        return !(this.f == null ? other.f != null : !this.f.equals(other.f));
    }
}

