/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.logic;

import com.ibm.wala.logic.AbstractVariable;
import com.ibm.wala.logic.IConstant;
import com.ibm.wala.logic.IFormula;
import com.ibm.wala.logic.ILogicConstants;
import com.ibm.wala.logic.ILogicDecorator;
import com.ibm.wala.logic.IMaxTerm;
import com.ibm.wala.logic.ITerm;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuantifiedFormula
implements IMaxTerm {
    private final IFormula f;
    private final ILogicConstants.Quantifier q;
    private final AbstractVariable boundV;

    private QuantifiedFormula(ILogicConstants.Quantifier q, AbstractVariable boundV, IFormula f) {
        this.f = f;
        this.q = q;
        this.boundV = boundV;
    }

    public static QuantifiedFormula forall(AbstractVariable v, IFormula formula) {
        return new QuantifiedFormula(ILogicConstants.Quantifier.FORALL, v, formula);
    }

    public static QuantifiedFormula forall(AbstractVariable v1, AbstractVariable v2, IFormula formula) {
        return new QuantifiedFormula(ILogicConstants.Quantifier.FORALL, v1, QuantifiedFormula.forall(v2, formula));
    }

    public static QuantifiedFormula forall(AbstractVariable v1, AbstractVariable v2, AbstractVariable v3, IFormula formula) {
        return new QuantifiedFormula(ILogicConstants.Quantifier.FORALL, v1, QuantifiedFormula.forall(v2, v3, formula));
    }

    public static IFormula make(ILogicConstants.Quantifier q, AbstractVariable v, IFormula f) {
        return new QuantifiedFormula(q, v, f);
    }

    @Override
    public IFormula.Kind getKind() {
        return IFormula.Kind.QUANTIFIED;
    }

    public AbstractVariable getBoundVar() {
        return this.boundV;
    }

    public IFormula getFormula() {
        return this.f;
    }

    public ILogicConstants.Quantifier getQuantifier() {
        return this.q;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.boundV == null ? 0 : this.boundV.hashCode());
        result = 31 * result + (this.f == null ? 0 : this.f.hashCode());
        result = 31 * result + (this.q == null ? 0 : this.q.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QuantifiedFormula other = (QuantifiedFormula)obj;
        if (this.boundV == null ? other.boundV != null : !this.boundV.equals(other.boundV)) {
            return false;
        }
        if (this.f == null ? other.f != null : !this.f.equals(other.f)) {
            return false;
        }
        return !(this.q == null ? other.q != null : !this.q.equals((Object)other.q));
    }

    @Override
    public Collection<AbstractVariable> getFreeVariables() {
        Collection<AbstractVariable> result = this.f.getFreeVariables();
        result.remove(this.boundV);
        return result;
    }

    @Override
    public Collection<? extends IConstant> getConstants() {
        return this.f.getConstants();
    }

    @Override
    public Collection<? extends ITerm> getAllTerms() {
        return this.f.getAllTerms();
    }

    public String toString() {
        return (Object)((Object)this.getQuantifier()) + " " + this.getBoundVar() + "." + this.getFormula();
    }

    @Override
    public String prettyPrint(ILogicDecorator d) throws IllegalArgumentException {
        if (d == null) {
            throw new IllegalArgumentException("d == null");
        }
        return String.valueOf(d.prettyPrint(this.getQuantifier())) + " " + d.prettyPrint(this.getBoundVar()) + "." + this.getFormula().prettyPrint(d);
    }

    @Override
    public Collection<? extends IMaxTerm> getMaxTerms() {
        return Collections.singleton(this);
    }
}

