/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.logic;

import com.ibm.wala.logic.AbstractVariable;
import com.ibm.wala.logic.BinaryRelation;
import com.ibm.wala.logic.DefaultDecorator;
import com.ibm.wala.logic.IConstant;
import com.ibm.wala.logic.IFormula;
import com.ibm.wala.logic.ILogicDecorator;
import com.ibm.wala.logic.IMaxTerm;
import com.ibm.wala.logic.IRelation;
import com.ibm.wala.logic.ITerm;
import com.ibm.wala.logic.IntConstant;
import com.ibm.wala.logic.UnaryRelation;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationFormula
implements IMaxTerm {
    private final IRelation R;
    private final List<ITerm> terms;

    public IRelation getRelation() {
        return this.R;
    }

    public List<ITerm> getTerms() {
        return this.terms;
    }

    @Override
    public Collection<? extends ITerm> getAllTerms() {
        Collection result = HashSetFactory.make();
        for (ITerm t : this.terms) {
            result.addAll(t.getAllTerms());
        }
        return result;
    }

    private RelationFormula(IRelation R, List<ITerm> terms) throws IllegalArgumentException {
        this.R = R;
        this.terms = terms;
        if (R == null) {
            throw new IllegalArgumentException("R cannot be null");
        }
    }

    public static RelationFormula make(BinaryRelation R, ITerm t1, ITerm t2) {
        ArrayList<ITerm> l = new ArrayList<ITerm>();
        l.add(t1);
        l.add(t2);
        return new RelationFormula(R, l);
    }

    public static RelationFormula make(BinaryRelation R, int i, ITerm t2) {
        return RelationFormula.make(R, (ITerm)IntConstant.make(i), t2);
    }

    public static RelationFormula make(BinaryRelation R, ITerm t1, int j) {
        return RelationFormula.make(R, t1, (ITerm)IntConstant.make(j));
    }

    public static RelationFormula make(BinaryRelation R, int i, int j) {
        return RelationFormula.make(R, (ITerm)IntConstant.make(i), (ITerm)IntConstant.make(j));
    }

    public static RelationFormula makeEquals(ITerm t1, ITerm t2) {
        return RelationFormula.make(BinaryRelation.EQUALS, t1, t2);
    }

    public static RelationFormula makeEquals(ITerm t1, int i) {
        return RelationFormula.make(BinaryRelation.EQUALS, t1, (ITerm)IntConstant.make(i));
    }

    public static RelationFormula make(UnaryRelation R, ITerm t) {
        ArrayList<ITerm> l = new ArrayList<ITerm>();
        l.add(t);
        return new RelationFormula(R, l);
    }

    public static RelationFormula make(UnaryRelation R, int i) {
        ArrayList<ITerm> l = new ArrayList<ITerm>();
        l.add(IntConstant.make(i));
        return new RelationFormula(R, l);
    }

    public static IFormula make(IRelation relation, List<ITerm> terms) {
        return new RelationFormula(relation, terms);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.R == null ? 0 : this.R.hashCode());
        result = 31 * result + (this.terms == null ? 0 : this.terms.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RelationFormula other = (RelationFormula)obj;
        if (this.R == null ? other.R != null : !this.R.equals(other.R)) {
            return false;
        }
        return !(this.terms == null ? other.terms != null : !this.terms.equals(other.terms));
    }

    @Override
    public IFormula.Kind getKind() {
        return IFormula.Kind.RELATION;
    }

    @Override
    public Collection<AbstractVariable> getFreeVariables() {
        Collection result = HashSetFactory.make(this.terms.size());
        for (ITerm t : this.terms) {
            result.addAll(t.getFreeVariables());
        }
        return result;
    }

    @Override
    public Collection<? extends IConstant> getConstants() {
        Collection result = HashSetFactory.make(this.terms.size());
        for (ITerm t : this.terms) {
            result.addAll(t.getConstants());
        }
        return result;
    }

    public String toString() {
        return this.prettyPrint(DefaultDecorator.instance());
    }

    @Override
    public String prettyPrint(ILogicDecorator d) throws IllegalArgumentException {
        if (d == null) {
            throw new IllegalArgumentException("d == null");
        }
        return d.prettyPrint(this);
    }

    public String prefixNotation(ILogicDecorator d) {
        StringBuffer result = new StringBuffer(this.R.getSymbol());
        result.append("(");
        int i = 0;
        while (i < this.R.getValence() - 1) {
            result.append(this.terms.get(i).prettyPrint(d));
            result.append(",");
            ++i;
        }
        if (this.R.getValence() > 0) {
            result.append(this.terms.get(this.R.getValence() - 1).prettyPrint(d));
        }
        result.append(")");
        return result.toString();
    }

    public String infixNotation(ILogicDecorator d) {
        assert (this.R.getValence() == 2);
        StringBuffer result = new StringBuffer();
        result.append(this.terms.get(0).prettyPrint(d));
        result.append(" ");
        result.append(this.R.getSymbol());
        result.append(" ");
        result.append(this.terms.get(1).prettyPrint(d));
        return result.toString();
    }

    @Override
    public Collection<? extends IMaxTerm> getMaxTerms() {
        return Collections.singleton(this);
    }
}

