/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.logic;

import com.ibm.wala.logic.AbstractBinaryFormula;
import com.ibm.wala.logic.AbstractVariable;
import com.ibm.wala.logic.BasicTheory;
import com.ibm.wala.logic.BinaryFormula;
import com.ibm.wala.logic.BinaryRelation;
import com.ibm.wala.logic.BooleanConstantFormula;
import com.ibm.wala.logic.CNFFormula;
import com.ibm.wala.logic.Disjunction;
import com.ibm.wala.logic.FunctionTerm;
import com.ibm.wala.logic.ICNFFormula;
import com.ibm.wala.logic.IFormula;
import com.ibm.wala.logic.ILogicConstants;
import com.ibm.wala.logic.IMaxTerm;
import com.ibm.wala.logic.ISemiDecisionProcedure;
import com.ibm.wala.logic.ITerm;
import com.ibm.wala.logic.ITheory;
import com.ibm.wala.logic.NotFormula;
import com.ibm.wala.logic.QuantifiedFormula;
import com.ibm.wala.logic.RelationFormula;
import com.ibm.wala.logic.Wildcard;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Simplifier {
    private static final boolean DEBUG = false;

    public static ITheory eliminateQuantifiers(ITheory t) {
        if (t == null) {
            throw new IllegalArgumentException("t is null");
        }
        Collection sentences = HashSetFactory.make();
        for (IFormula iFormula : t.getSentences()) {
            sentences.addAll(Simplifier.eliminateQuantifiers(iFormula));
        }
        return BasicTheory.make(t.getVocabulary(), sentences);
    }

    private static Collection<? extends IFormula> eliminateQuantifiers(IFormula s) {
        Assertions.UNREACHABLE("implement me");
        return null;
    }

    public static Collection<? extends IFormula> eliminateQuantifiers(Collection<? extends IFormula> s) {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        Collection result = HashSetFactory.make();
        for (IFormula iFormula : s) {
            result.addAll(Simplifier.eliminateQuantifiers(iFormula));
        }
        return result;
    }

    public static Collection<IFormula> simplify(Collection<IFormula> s, Collection<? extends IFormula> theory, ISemiDecisionProcedure dec) {
        return Simplifier.propositionalSimplify(s, theory, dec);
    }

    public static Collection<IFormula> propositionalSimplify(Collection<IFormula> s, Collection<? extends IFormula> t, ISemiDecisionProcedure dec) {
        Simplifier.debug1(s, t);
        Collection<ICNFFormula> cs = Simplifier.toCNF(s);
        Collection<ICNFFormula> ct = Simplifier.toCNF(t);
        Simplifier.debug2(cs, ct);
        Collection<IMaxTerm> facts = Simplifier.collectClauses(ct);
        Collection result = HashSetFactory.make();
        for (ICNFFormula f : cs) {
            Collection<? extends IMaxTerm> d = Simplifier.simplifyCNF(f, facts, dec);
            result.add(CNFFormula.make(d));
        }
        return result;
    }

    public static IFormula propositionalSimplify(IFormula f, Collection<? extends IFormula> t, ISemiDecisionProcedure dec) {
        Collection<IFormula> result = Simplifier.propositionalSimplify((Collection<IFormula>)Collections.singleton(f), t, dec);
        return result.iterator().next();
    }

    private static Collection<? extends IMaxTerm> simplifyCNF(ICNFFormula f, Collection<IMaxTerm> facts, ISemiDecisionProcedure dec) {
        Collection result = HashSetFactory.make();
        Collection removedClauses = HashSetFactory.make();
        for (IMaxTerm iMaxTerm : f.getMaxTerms()) {
            Collection otherFacts = HashSetFactory.make(facts);
            otherFacts.addAll(f.getMaxTerms());
            otherFacts.remove(iMaxTerm);
            otherFacts.removeAll(removedClauses);
            IMaxTerm checkD = iMaxTerm;
            if (iMaxTerm instanceof Disjunction) {
                checkD = Simplifier.simplifyDisjunction((Disjunction)iMaxTerm, otherFacts, dec);
            }
            if (dec.isContradiction(checkD, otherFacts)) {
                return Collections.singleton(BooleanConstantFormula.FALSE);
            }
            if (facts.contains(checkD) || dec.isTautology(checkD, otherFacts)) {
                removedClauses.add(iMaxTerm);
                continue;
            }
            result.add(checkD);
        }
        if (result.isEmpty()) {
            return Collections.singleton(BooleanConstantFormula.TRUE);
        }
        return result;
    }

    private static IMaxTerm simplifyDisjunction(Disjunction d, Collection<IMaxTerm> otherFacts, ISemiDecisionProcedure dec) {
        Collection result = HashSetFactory.make();
        for (IFormula iFormula : d.getClauses()) {
            if (dec.isContradiction(iFormula, otherFacts)) {
                result.add(BooleanConstantFormula.FALSE);
                continue;
            }
            if (dec.isTautology(iFormula, otherFacts)) {
                result.add(BooleanConstantFormula.TRUE);
                continue;
            }
            result.add(iFormula);
        }
        if (result.size() == 1) {
            IFormula iFormula = (IFormula)result.iterator().next();
            assert (iFormula instanceof IMaxTerm);
            return (IMaxTerm)iFormula;
        }
        return Disjunction.make(result);
    }

    private static Collection<IMaxTerm> collectClauses(Collection<ICNFFormula> s) {
        Collection result = HashSetFactory.make();
        for (ICNFFormula f : s) {
            if (f instanceof CNFFormula) {
                result.addAll(f.getMaxTerms());
                continue;
            }
            result.add((IMaxTerm)f);
        }
        return result;
    }

    private static void debug2(Collection<ICNFFormula> cs, Collection<ICNFFormula> ct) {
    }

    private static void debug1(Collection<IFormula> s, Collection<? extends IFormula> t) {
    }

    private static Collection<ICNFFormula> toCNF(Collection<? extends IFormula> s) {
        Collection result = HashSetFactory.make();
        for (IFormula iFormula : s) {
            result.add(CNFFormula.make(iFormula));
        }
        return result;
    }

    static boolean innerStructureMatches(QuantifiedFormula q, IFormula f) {
        IFormula g = Simplifier.innermost(q);
        return f.getKind().equals((Object)g.getKind());
    }

    public static IFormula innermost(QuantifiedFormula q) throws IllegalArgumentException {
        if (q == null) {
            throw new IllegalArgumentException("q == null");
        }
        IFormula g = q.getFormula();
        if (g.getKind().equals((Object)IFormula.Kind.QUANTIFIED)) {
            return Simplifier.innermost((QuantifiedFormula)g);
        }
        return g;
    }

    public static IFormula substitute(IFormula formula, ITerm t1, ITerm t2) {
        if (formula == null) {
            throw new IllegalArgumentException("formula is null");
        }
        switch (formula.getKind()) {
            case BINARY: {
                AbstractBinaryFormula b = (AbstractBinaryFormula)formula;
                return BinaryFormula.make(b.getConnective(), Simplifier.substitute(b.getF1(), t1, t2), Simplifier.substitute(b.getF2(), t1, t2));
            }
            case NEGATION: {
                NotFormula n = (NotFormula)formula;
                return NotFormula.make(Simplifier.substitute(n.getFormula(), t1, t2));
            }
            case QUANTIFIED: {
                QuantifiedFormula q = (QuantifiedFormula)formula;
                if (q.getBoundVar().equals(t1)) {
                    return q;
                }
                return QuantifiedFormula.make(q.getQuantifier(), q.getBoundVar(), Simplifier.substitute(q.getFormula(), t1, t2));
            }
            case RELATION: {
                RelationFormula r = (RelationFormula)formula;
                LinkedList<ITerm> terms = new LinkedList<ITerm>();
                for (ITerm t : r.getTerms()) {
                    Map binding = HashMapFactory.make();
                    terms.add(Simplifier.substitute(t, t1, t2, binding));
                }
                return RelationFormula.make(r.getRelation(), terms);
            }
            case CONSTANT: {
                return formula;
            }
        }
        Assertions.UNREACHABLE();
        return null;
    }

    public static ITerm substitute(ITerm t, ITerm t1, ITerm t2, Map<Wildcard, ITerm> binding) {
        assert (t != null);
        assert (t1 != null);
        assert (t2 != null);
        if (Simplifier.termsMatch(t, t1, binding)) {
            ITerm result = Simplifier.bindingOf(t2, binding);
            assert (result != null);
            return result;
        }
        switch (t.getKind()) {
            case CONSTANT: {
                return t;
            }
            case FUNCTION: {
                FunctionTerm f = (FunctionTerm)t;
                LinkedList<ITerm> terms = new LinkedList<ITerm>();
                for (ITerm p : f.getParameters()) {
                    terms.add(Simplifier.substitute(p, t1, t2, binding));
                }
                return FunctionTerm.make(f.getFunction(), terms);
            }
            case VARIABLE: {
                if (t1.equals(t)) {
                    return t2;
                }
                return t;
            }
        }
        Assertions.UNREACHABLE();
        return null;
    }

    private static ITerm bindingOf(ITerm t, Map<Wildcard, ITerm> binding) {
        assert (t != null);
        switch (t.getKind()) {
            case CONSTANT: {
                if (t instanceof Wildcard) {
                    ITerm result = binding.get(t);
                    if (result == null) {
                        return t;
                    }
                    return result;
                }
                return t;
            }
            case VARIABLE: {
                return t;
            }
            case FUNCTION: {
                FunctionTerm ft = (FunctionTerm)t;
                ArrayList<ITerm> terms = new ArrayList<ITerm>();
                for (ITerm p : ft.getParameters()) {
                    terms.add(Simplifier.bindingOf(p, binding));
                }
                return FunctionTerm.make(ft.getFunction(), terms);
            }
        }
        Assertions.UNREACHABLE(t);
        return null;
    }

    private static boolean termsMatch(ITerm t1, ITerm t2, Map<Wildcard, ITerm> binding) {
        if (t1.equals(t2)) {
            return true;
        }
        if (t2 instanceof Wildcard) {
            Wildcard w = (Wildcard)t2;
            ITerm b = binding.get(w);
            if (b != null) {
                return b.equals(t1);
            }
            binding.put(w, t1);
            return true;
        }
        switch (t1.getKind()) {
            case CONSTANT: 
            case VARIABLE: {
                return false;
            }
            case FUNCTION: {
                if (t2 instanceof FunctionTerm) {
                    FunctionTerm f1 = (FunctionTerm)t1;
                    FunctionTerm f2 = (FunctionTerm)t2;
                    if (f1.getFunction().equals(f2.getFunction())) {
                        int i = 0;
                        while (i < f1.getParameters().size()) {
                            ITerm y;
                            ITerm x = f1.getParameters().get(i);
                            if (!Simplifier.termsMatch(x, y = f2.getParameters().get(i), binding)) {
                                return false;
                            }
                            ++i;
                        }
                        return true;
                    }
                }
                return false;
            }
        }
        Assertions.UNREACHABLE();
        return false;
    }

    public static Collection<AbstractVariable> getFreeVariables(Collection<? extends IFormula> constraints) {
        if (constraints == null) {
            throw new IllegalArgumentException("constraints is null");
        }
        Collection free = HashSetFactory.make();
        for (IFormula iFormula : constraints) {
            free.addAll(iFormula.getFreeVariables());
        }
        return free;
    }

    public static IFormula distributeNot(NotFormula f) throws IllegalArgumentException {
        if (f == null) {
            throw new IllegalArgumentException("f == null");
        }
        IFormula f1 = f.getFormula();
        if (f1 instanceof RelationFormula) {
            RelationFormula r = (RelationFormula)f1;
            BinaryRelation negate = BinaryRelation.negate(r.getRelation());
            if (negate == null) {
                return f;
            }
            return RelationFormula.make(negate, r.getTerms());
        }
        if (f1 instanceof AbstractBinaryFormula) {
            AbstractBinaryFormula bf = (AbstractBinaryFormula)f1;
            if (bf.getConnective().equals((Object)ILogicConstants.BinaryConnective.AND)) {
                IFormula notA = NotFormula.make(bf.getF1());
                IFormula notB = NotFormula.make(bf.getF2());
                if (notA instanceof NotFormula) {
                    notA = Simplifier.distributeNot((NotFormula)notA);
                }
                if (notB instanceof NotFormula) {
                    notB = Simplifier.distributeNot((NotFormula)notB);
                }
                return BinaryFormula.or(notA, notB);
            }
            if (bf.getConnective().equals((Object)ILogicConstants.BinaryConnective.OR)) {
                IFormula notA = NotFormula.make(bf.getF1());
                IFormula notB = NotFormula.make(bf.getF2());
                if (notA instanceof NotFormula) {
                    notA = Simplifier.distributeNot((NotFormula)notA);
                }
                if (notB instanceof NotFormula) {
                    notB = Simplifier.distributeNot((NotFormula)notB);
                }
                return BinaryFormula.and(notA, notB);
            }
        }
        return f;
    }

    public static IFormula simplify(IFormula f, ISemiDecisionProcedure dec) {
        Collection emptyTheory = Collections.emptySet();
        Collection single = Collections.singleton(f);
        Collection<IFormula> result = Simplifier.propositionalSimplify(single, (Collection<? extends IFormula>)emptyTheory, dec);
        assert (result.size() == 1);
        return result.iterator().next();
    }

    public static IFormula propositionalSimplify(IFormula f, ISemiDecisionProcedure dec) {
        Collection emptySet = Collections.emptySet();
        Collection singleton = Collections.singleton(f);
        Collection<IFormula> result = Simplifier.propositionalSimplify(singleton, (Collection<? extends IFormula>)emptySet, dec);
        assert (result.size() == 1);
        return result.iterator().next();
    }

    public static IFormula simplify(IFormula f, IFormula t, ISemiDecisionProcedure dec) {
        Collection<IFormula> s = Simplifier.simplify((Collection<IFormula>)Collections.singleton(f), (Collection<? extends IFormula>)Collections.singleton(t), dec);
        assert (s.size() == 1);
        return s.iterator().next();
    }
}

