/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.logic;

import com.ibm.wala.logic.FunctionTerm;
import com.ibm.wala.logic.IFormula;
import com.ibm.wala.logic.IFunction;
import com.ibm.wala.logic.ITerm;
import com.ibm.wala.logic.RelationFormula;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.intset.IBinaryNaturalRelation;
import com.ibm.wala.util.intset.IntPair;
import com.ibm.wala.util.intset.IntSet;
import java.util.Collection;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnaryFunction
implements IFunction {
    private final String symbol;

    protected UnaryFunction(String symbol) {
        this.symbol = symbol;
    }

    public static UnaryFunction make(String symbol) {
        return new UnaryFunction(symbol);
    }

    @Override
    public int getNumberOfParameters() {
        return 1;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    public static Collection<IFormula> buildConstraints(IBinaryNaturalRelation R, UnaryFunction f, IntPair domain) {
        if (domain == null) {
            throw new IllegalArgumentException("domain is null");
        }
        Set result = HashSetFactory.make();
        int i = domain.getX();
        while (i <= domain.getY()) {
            IntSet s = R.getRelated(i);
            if (s != null) {
                assert (s.size() == 1);
                result.add(RelationFormula.makeEquals((ITerm)FunctionTerm.make(f, i), s.intIterator().next()));
            } else {
                result.add(RelationFormula.makeEquals((ITerm)FunctionTerm.make(f, i), -1));
            }
            ++i;
        }
        return result;
    }

    public String toString() {
        return String.valueOf(this.getSymbol()) + " : int -> int";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.symbol == null ? 0 : this.symbol.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnaryFunction other = (UnaryFunction)obj;
        return !(this.symbol == null ? other.symbol != null : !this.symbol.equals(other.symbol));
    }
}

