/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.properties;

import com.ibm.wala.core.plugin.CorePlugin;
import com.ibm.wala.util.config.FileProvider;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.io.FileUtil;
import com.ibm.wala.util.warnings.WalaException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Properties;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public final class WalaProperties {
    public static final String WALA_REPORT = "WALA_report";
    public static final String INPUT_DIR = "input_dir";
    public static final String OUTPUT_DIR = "output_dir";
    public static final String J2SE_DIR = "java_runtime_dir";
    public static final String J2EE_DIR = "j2ee_runtime_dir";
    public static final String ECLIPSE_PLUGINS_DIR = "eclipse_plugins_dir";
    static final String PROPERTY_FILENAME = "wala.properties";

    public static String[] getJ2SEJarFiles() {
        Properties p = null;
        try {
            p = WalaProperties.loadProperties();
        }
        catch (WalaException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
        }
        String dir = p.getProperty(J2SE_DIR);
        Assertions.productionAssertion(dir != null);
        return WalaProperties.getJarsInDirectory(dir);
    }

    public static String[] getJ2EEJarFiles() {
        Properties p = null;
        try {
            p = WalaProperties.loadProperties();
        }
        catch (WalaException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
        }
        String dir = p.getProperty(J2EE_DIR);
        Assertions.productionAssertion(dir != null);
        return WalaProperties.getJarsInDirectory(dir);
    }

    private static String[] getJarsInDirectory(String dir) {
        File f = new File(dir);
        Assertions.productionAssertion(f.isDirectory(), "not a directory: " + dir);
        Collection<File> col = FileUtil.listFiles(dir, ".*\\.jar$", true);
        String[] result = new String[col.size()];
        int i = 0;
        for (File jarFile : col) {
            result[i++] = jarFile.getAbsolutePath();
        }
        return result;
    }

    public static Properties loadProperties() throws WalaException {
        try {
            Properties result = WalaProperties.loadPropertiesFromFile(WalaProperties.class.getClassLoader(), PROPERTY_FILENAME);
            String outputDir = result.getProperty(OUTPUT_DIR, "results");
            result.setProperty(OUTPUT_DIR, WalaProperties.convertToAbsolute(outputDir));
            String walaReport = result.getProperty(WALA_REPORT, "wala_report.txt");
            result.setProperty(WALA_REPORT, WalaProperties.convertToAbsolute(walaReport));
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WalaException("Unable to set up wala properties ", e);
        }
    }

    static String convertToAbsolute(String path) {
        File file = new File(path);
        return file.isAbsolute() ? file.getAbsolutePath() : WalaProperties.getWalaHomeDir().concat(File.separator).concat(path);
    }

    public static Properties loadPropertiesFromFile(ClassLoader loader, String fileName) throws IOException {
        if (loader == null) {
            throw new IllegalArgumentException("loader is null");
        }
        InputStream propertyStream = loader.getResourceAsStream(fileName);
        if (propertyStream == null) {
            throw new IOException("property_file_unreadable " + fileName);
        }
        Properties result = new Properties();
        result.load(propertyStream);
        return result;
    }

    @Deprecated
    public static String getWalaHomeDir() {
        String envProperty = System.getProperty("WALA_HOME");
        if (envProperty != null) {
            return envProperty;
        }
        URL url = WalaProperties.class.getClassLoader().getResource(PROPERTY_FILENAME);
        if (url == null) {
            return System.getProperty("user.dir");
        }
        return new File(FileProvider.filePathFromURL(url)).getParentFile().getParentFile().getPath().toString();
    }

    public static String getWalaCorePluginHome() {
        if (CorePlugin.getDefault() == null) {
            return null;
        }
        String install = Platform.getInstallLocation().getURL().getPath();
        Bundle b = Platform.getBundle((String)"com.ibm.wala.core");
        String l = b.getLocation();
        if (l.startsWith("update@")) {
            l = l.replace("update@", "");
        }
        return String.valueOf(install) + File.separator + l;
    }
}

