/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT.analysis;

import com.ibm.wala.shrikeBT.ArrayLengthInstruction;
import com.ibm.wala.shrikeBT.ArrayLoadInstruction;
import com.ibm.wala.shrikeBT.ArrayStoreInstruction;
import com.ibm.wala.shrikeBT.BinaryOpInstruction;
import com.ibm.wala.shrikeBT.CheckCastInstruction;
import com.ibm.wala.shrikeBT.ComparisonInstruction;
import com.ibm.wala.shrikeBT.ConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.ConstantInstruction;
import com.ibm.wala.shrikeBT.ConversionInstruction;
import com.ibm.wala.shrikeBT.DupInstruction;
import com.ibm.wala.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrikeBT.GetInstruction;
import com.ibm.wala.shrikeBT.GotoInstruction;
import com.ibm.wala.shrikeBT.InstanceofInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.InvokeInstruction;
import com.ibm.wala.shrikeBT.LoadInstruction;
import com.ibm.wala.shrikeBT.MethodData;
import com.ibm.wala.shrikeBT.MonitorInstruction;
import com.ibm.wala.shrikeBT.NewInstruction;
import com.ibm.wala.shrikeBT.PopInstruction;
import com.ibm.wala.shrikeBT.PutInstruction;
import com.ibm.wala.shrikeBT.ReturnInstruction;
import com.ibm.wala.shrikeBT.ShiftInstruction;
import com.ibm.wala.shrikeBT.StoreInstruction;
import com.ibm.wala.shrikeBT.SwitchInstruction;
import com.ibm.wala.shrikeBT.ThrowInstruction;
import com.ibm.wala.shrikeBT.UnaryOpInstruction;
import com.ibm.wala.shrikeBT.Util;
import com.ibm.wala.shrikeBT.analysis.Analyzer;
import java.util.BitSet;
import java.util.List;

public final class Verifier
extends Analyzer {
    public Verifier(boolean isStatic, String classType, String signature, Instruction[] instructions, ExceptionHandler[][] handlers) {
        super(isStatic, classType, signature, instructions, handlers);
    }

    public Verifier(MethodData info) throws NullPointerException {
        super(info);
    }

    public void verify() throws Analyzer.FailureException {
        VerifyVisitor v = new VerifyVisitor();
        this.computeTypes(v, this.getBasicBlockStarts(), true);
        v.checkError();
    }

    public void verifyCollectAll() throws Analyzer.FailureException {
        VerifyVisitor v = new VerifyVisitor();
        BitSet all = new BitSet(this.instructions.length);
        all.set(0, this.instructions.length);
        this.computeTypes(v, all, true);
        v.checkError();
    }

    public void computeTypes() throws Analyzer.FailureException {
        this.computeTypes(null, this.getBasicBlockStarts(), false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class VerifyVisitor
    extends Analyzer.TypeVisitor {
        private int curIndex;
        private List<Analyzer.PathElement> curPath;
        private Analyzer.FailureException ex;
        private String[] curStack;
        private String[] curLocals;

        VerifyVisitor() {
            super(Verifier.this);
        }

        @Override
        public void setState(int offset, List<Analyzer.PathElement> path, String[] curStack, String[] curLocals) {
            this.curIndex = offset;
            this.curPath = path;
            this.curStack = curStack;
            this.curLocals = curLocals;
        }

        @Override
        public boolean shouldContinue() {
            return this.ex == null;
        }

        void checkError() throws Analyzer.FailureException {
            if (this.ex != null) {
                throw this.ex;
            }
        }

        private void checkStackSubtype(int i, String t) {
            if (!Verifier.this.isSubtypeOf(this.curStack[i], Util.getStackType(t))) {
                this.ex = new Analyzer.FailureException(this.curIndex, "Expected type " + t + " at stack " + i + ", got " + this.curStack[i], this.curPath);
            }
        }

        private void checkArrayStackSubtype(int i, String t) {
            if (!t.equals("B") || !"[Z".equals(this.curStack[i])) {
                this.checkStackSubtype(i, Util.makeArray(t));
            }
        }

        @Override
        public void visitConstant(ConstantInstruction instruction) {
            instruction.getValue();
        }

        @Override
        public void visitGoto(GotoInstruction instruction) {
        }

        @Override
        public void visitLocalLoad(LoadInstruction instruction) {
            String t = this.curLocals[instruction.getVarIndex()];
            if (t == null) {
                this.ex = new Analyzer.FailureException(this.curIndex, "Local variable " + instruction.getVarIndex() + " is not defined", this.curPath);
            }
            if (!Verifier.this.isSubtypeOf(t, instruction.getType())) {
                this.ex = new Analyzer.FailureException(this.curIndex, "Expected type " + instruction.getType() + " for local " + instruction.getVarIndex() + ", got " + t, this.curPath);
            }
        }

        @Override
        public void visitLocalStore(StoreInstruction instruction) {
            this.checkStackSubtype(0, instruction.getType());
        }

        @Override
        public void visitArrayLoad(ArrayLoadInstruction instruction) {
            this.checkStackSubtype(0, "I");
            this.checkArrayStackSubtype(1, instruction.getType());
        }

        @Override
        public void visitArrayStore(ArrayStoreInstruction instruction) {
            this.checkStackSubtype(0, instruction.getType());
            this.checkStackSubtype(1, "I");
            this.checkArrayStackSubtype(2, instruction.getType());
        }

        @Override
        public void visitPop(PopInstruction instruction) {
        }

        @Override
        public void visitDup(DupInstruction instruction) {
        }

        @Override
        public void visitBinaryOp(BinaryOpInstruction instruction) {
            this.checkStackSubtype(0, instruction.getType());
            this.checkStackSubtype(1, instruction.getType());
        }

        @Override
        public void visitUnaryOp(UnaryOpInstruction instruction) {
            this.checkStackSubtype(0, instruction.getType());
        }

        @Override
        public void visitShift(ShiftInstruction instruction) {
            this.checkStackSubtype(0, "I");
            this.checkStackSubtype(1, instruction.getType());
        }

        @Override
        public void visitConversion(ConversionInstruction instruction) {
            this.checkStackSubtype(0, instruction.getFromType());
        }

        @Override
        public void visitComparison(ComparisonInstruction instruction) {
            this.checkStackSubtype(0, instruction.getType());
            this.checkStackSubtype(1, instruction.getType());
        }

        @Override
        public void visitConditionalBranch(ConditionalBranchInstruction instruction) {
            this.checkStackSubtype(0, instruction.getType());
            this.checkStackSubtype(1, instruction.getType());
        }

        @Override
        public void visitSwitch(SwitchInstruction instruction) {
            this.checkStackSubtype(0, "I");
        }

        @Override
        public void visitReturn(ReturnInstruction instruction) {
            if (instruction.getType() != "V") {
                this.checkStackSubtype(0, instruction.getType());
                this.checkStackSubtype(0, Util.getReturnType(Verifier.this.signature));
            }
        }

        @Override
        public void visitGet(GetInstruction instruction) {
            String classType = instruction.getClassType();
            if (!instruction.isStatic()) {
                this.checkStackSubtype(0, classType);
            }
        }

        @Override
        public void visitPut(PutInstruction instruction) {
            String classType = instruction.getClassType();
            String type = instruction.getFieldType();
            this.checkStackSubtype(0, type);
            if (!instruction.isStatic()) {
                this.checkStackSubtype(1, classType);
            }
        }

        @Override
        public void visitInvoke(InvokeInstruction instruction) {
            String classType = instruction.getClassType();
            String signature = instruction.getMethodSignature();
            String thisClass = instruction.getInvocationMode() == 184 ? null : classType;
            String[] params = Util.getParamsTypes(thisClass, signature);
            int i = 0;
            while (i < params.length) {
                this.checkStackSubtype(i, params[params.length - 1 - i]);
                ++i;
            }
        }

        @Override
        public void visitNew(NewInstruction instruction) {
            int i = 0;
            while (i < instruction.getArrayBoundsCount()) {
                this.checkStackSubtype(i, "I");
                ++i;
            }
            instruction.getType();
        }

        @Override
        public void visitArrayLength(ArrayLengthInstruction instruction) {
            if (!this.curStack[0].equals("L;") && !Util.isArrayType(this.curStack[0])) {
                this.ex = new Analyzer.FailureException(this.curIndex, "Expected array type at stack 0, got " + this.curStack[0], this.curPath);
            }
        }

        @Override
        public void visitThrow(ThrowInstruction instruction) {
            this.checkStackSubtype(0, "Ljava/lang/Throwable;");
        }

        @Override
        public void visitMonitor(MonitorInstruction instruction) {
            this.checkStackSubtype(0, "Ljava/lang/Object;");
        }

        @Override
        public void visitCheckCast(CheckCastInstruction instruction) {
            this.checkStackSubtype(0, "Ljava/lang/Object;");
            instruction.getType();
        }

        @Override
        public void visitInstanceof(InstanceofInstruction instruction) {
            this.checkStackSubtype(0, "Ljava/lang/Object;");
            instruction.getType();
        }
    }
}

