/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeCT;

import com.ibm.wala.shrikeCT.ClassConstants;
import com.ibm.wala.shrikeCT.InvalidClassFileException;

public final class ConstantPoolParser
implements ClassConstants {
    private final byte[] bytes;
    private int[] cpOffsets;
    private String[] cpItems;

    public ConstantPoolParser(byte[] bytes, int offset, int itemCount) throws InvalidClassFileException {
        this.bytes = bytes;
        this.parseConstantPool(offset, itemCount);
    }

    public byte[] getRawBytes() {
        return this.bytes;
    }

    public int getRawOffset() throws IllegalStateException {
        if (this.cpOffsets.length < 2) {
            throw new IllegalStateException();
        }
        return this.cpOffsets[1];
    }

    public int getRawSize() throws IllegalStateException {
        if (this.cpOffsets.length < 2) {
            throw new IllegalStateException();
        }
        return this.cpOffsets[this.cpOffsets.length - 1] - this.cpOffsets[1];
    }

    public int getItemCount() {
        return this.cpOffsets.length - 1;
    }

    private void checkLength(int offset, int required) throws InvalidClassFileException {
        if (this.bytes.length < offset + required) {
            throw new InvalidClassFileException(offset, "file truncated, expected " + required + " bytes, saw only " + (this.bytes.length - offset));
        }
    }

    public byte getItemType(int i) throws IllegalArgumentException {
        if (i < 1 || i >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + i + " out of range");
        }
        int offset = this.cpOffsets[i];
        if (offset == 0) {
            return 0;
        }
        return this.getByte(offset);
    }

    public String getCPClass(int i) throws InvalidClassFileException, IllegalArgumentException {
        if (i < 1 || i >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + i + " out of range");
        }
        int offset = this.cpOffsets[i];
        if (offset == 0 || this.getByte(offset) != 7) {
            throw new IllegalArgumentException("Constant pool item #" + i + " is not a Class");
        }
        String s = this.cpItems[i];
        if (s == null) {
            try {
                s = this.getCPUtf8(this.getUShort(offset + 1));
            }
            catch (IllegalArgumentException ex) {
                throw new InvalidClassFileException(offset, "Invalid class name at constant pool item #" + i + ": " + ex.getMessage());
            }
            this.cpItems[i] = s;
        }
        return s;
    }

    public String getCPString(int i) throws InvalidClassFileException, IllegalArgumentException {
        if (i < 1 || i >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + i + " out of range");
        }
        int offset = this.cpOffsets[i];
        if (offset == 0 || this.getByte(offset) != 8) {
            throw new IllegalArgumentException("Constant pool item #" + i + " is not a String");
        }
        String s = this.cpItems[i];
        if (s == null) {
            try {
                s = this.getCPUtf8(this.getUShort(offset + 1));
            }
            catch (IllegalArgumentException ex) {
                throw new InvalidClassFileException(offset, "Invalid string at constant pool item #" + i + ": " + ex.getMessage());
            }
            this.cpItems[i] = s;
        }
        return s;
    }

    private static boolean isRef(byte b) {
        switch (b) {
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    public String getCPRefClass(int i) throws InvalidClassFileException, IllegalArgumentException {
        if (i < 1 || i >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + i + " out of range");
        }
        int offset = this.cpOffsets[i];
        if (offset == 0 || !ConstantPoolParser.isRef(this.getByte(offset))) {
            throw new IllegalArgumentException("Constant pool item #" + i + " is not a Ref");
        }
        try {
            return this.getCPClass(this.getUShort(offset + 1));
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidClassFileException(offset, "Invalid Ref class at constant pool item #" + i + ": " + ex.getMessage());
        }
    }

    public String getCPRefName(int i) throws InvalidClassFileException, IllegalArgumentException {
        if (i < 1 || i >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + i + " out of range");
        }
        int offset = this.cpOffsets[i];
        if (offset == 0 || !ConstantPoolParser.isRef(this.getByte(offset))) {
            throw new IllegalArgumentException("Constant pool item #" + i + " is not a Ref");
        }
        try {
            return this.getCPNATName(this.getUShort(offset + 3));
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidClassFileException(offset, "Invalid Ref NameAndType at constant pool item #" + i + ": " + ex.getMessage());
        }
    }

    public String getCPRefType(int i) throws InvalidClassFileException, IllegalArgumentException {
        if (i < 1 || i >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + i + " out of range");
        }
        int offset = this.cpOffsets[i];
        if (offset == 0 || !ConstantPoolParser.isRef(this.getByte(offset))) {
            throw new IllegalArgumentException("Constant pool item #" + i + " is not a Ref");
        }
        try {
            return this.getCPNATType(this.getUShort(offset + 3));
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidClassFileException(offset, "Invalid Ref NameAndType at constant pool item #" + i + ": " + ex.getMessage());
        }
    }

    public String getCPNATName(int i) throws InvalidClassFileException, IllegalArgumentException {
        if (i < 1 || i >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + i + " out of range");
        }
        int offset = this.cpOffsets[i];
        if (offset == 0 || this.getByte(offset) != 12) {
            throw new IllegalArgumentException("Constant pool item #" + i + " is not a NameAndType");
        }
        try {
            return this.getCPUtf8(this.getUShort(offset + 1));
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidClassFileException(offset, "Invalid NameAndType name at constant pool item #" + i + ": " + ex.getMessage());
        }
    }

    public String getCPNATType(int i) throws InvalidClassFileException, IllegalArgumentException {
        if (i < 1 || i >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + i + " out of range");
        }
        int offset = this.cpOffsets[i];
        if (offset == 0 || this.getByte(offset) != 12) {
            throw new IllegalArgumentException("Constant pool item #" + i + " is not a NameAndType");
        }
        try {
            return this.getCPUtf8(this.getUShort(offset + 3));
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidClassFileException(offset, "Invalid NameAndType type at constant pool item #" + i + ": " + ex.getMessage());
        }
    }

    public int getCPInt(int i) throws InvalidClassFileException, IllegalArgumentException {
        if (i < 1 || i >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + i + " out of range");
        }
        int offset = this.cpOffsets[i];
        if (offset == 0 || this.getByte(offset) != 3) {
            throw new IllegalArgumentException("Constant pool item #" + i + " is not an Integer");
        }
        return this.getInt(offset + 1);
    }

    public float getCPFloat(int i) throws InvalidClassFileException, IllegalArgumentException {
        if (i < 1 || i >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + i + " out of range");
        }
        int offset = this.cpOffsets[i];
        if (offset == 0 || this.getByte(offset) != 4) {
            throw new IllegalArgumentException("Constant pool item #" + i + " is not a Float");
        }
        return this.getFloat(offset + 1);
    }

    public long getCPLong(int i) throws InvalidClassFileException, IllegalArgumentException {
        if (i < 1 || i >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + i + " out of range");
        }
        int offset = this.cpOffsets[i];
        if (offset == 0 || this.getByte(offset) != 5) {
            throw new IllegalArgumentException("Constant pool item #" + i + " is not a Long");
        }
        return this.getLong(offset + 1);
    }

    public double getCPDouble(int i) throws InvalidClassFileException, IllegalArgumentException {
        if (i < 1 || i >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + i + " out of range");
        }
        int offset = this.cpOffsets[i];
        if (offset == 0 || this.getByte(offset) != 6) {
            throw new IllegalArgumentException("Constant pool item #" + i + " is not a Double");
        }
        return this.getDouble(offset + 1);
    }

    private InvalidClassFileException invalidUtf8(int item, int offset) {
        return new InvalidClassFileException(offset, "Constant pool item #" + item + " starting at " + this.cpOffsets[item] + ", is an invalid Java Utf8 string (byte is " + this.getByte(offset) + ")");
    }

    public String getCPUtf8(int i) throws InvalidClassFileException, IllegalArgumentException {
        if (i < 1 || i >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + i + " out of range");
        }
        int offset = this.cpOffsets[i];
        if (offset == 0 || this.getByte(offset) != 1) {
            throw new IllegalArgumentException("Constant pool item #" + i + " is not a Utf8");
        }
        String s = this.cpItems[i];
        if (s == null) {
            int count = this.getUShort(offset + 1);
            int end = count + offset + 3;
            StringBuffer buf = new StringBuffer(count);
            offset += 3;
            while (offset < end) {
                byte y;
                byte x = this.getByte(offset);
                if ((x & 0x80) == 0) {
                    if (x == 0) {
                        throw this.invalidUtf8(i, offset);
                    }
                    buf.append((char)x);
                    ++offset;
                    continue;
                }
                if ((x & 0xE0) == 192) {
                    if (offset + 1 >= end) {
                        throw this.invalidUtf8(i, offset);
                    }
                    y = this.getByte(offset + 1);
                    if ((y & 0xC0) != 128) {
                        throw this.invalidUtf8(i, offset);
                    }
                    buf.append((char)(((x & 0x1F) << 6) + (y & 0x3F)));
                    offset += 2;
                    continue;
                }
                if ((x & 0xF0) == 224) {
                    if (offset + 2 >= end) {
                        throw this.invalidUtf8(i, offset);
                    }
                    y = this.getByte(offset + 1);
                    byte z = this.getByte(offset + 2);
                    if ((y & 0xC0) != 128 || (z & 0xC0) != 128) {
                        throw this.invalidUtf8(i, offset);
                    }
                    buf.append((char)(((x & 0xF) << 12) + ((y & 0x3F) << 6) + (z & 0x3F)));
                    offset += 3;
                    continue;
                }
                throw this.invalidUtf8(i, offset);
            }
            this.cpItems[i] = s = buf.toString().intern();
        }
        return s;
    }

    private void parseConstantPool(int offset, int itemCount) throws InvalidClassFileException {
        this.cpOffsets = new int[itemCount + 1];
        this.cpItems = new String[itemCount];
        int i = 1;
        while (i < itemCount) {
            int itemLen;
            this.cpOffsets[i] = offset;
            byte tag = this.getByte(offset);
            switch (tag) {
                case 7: 
                case 8: {
                    itemLen = 2;
                    break;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    itemLen = 4;
                    break;
                }
                case 5: 
                case 6: {
                    itemLen = 8;
                    ++i;
                    break;
                }
                case 1: {
                    itemLen = 2 + this.getUShort(offset + 1);
                    break;
                }
                default: {
                    throw new InvalidClassFileException(offset, "unknown constant pool entry type" + tag);
                }
            }
            this.checkLength(offset, itemLen);
            offset += itemLen + 1;
            ++i;
        }
        this.cpOffsets[itemCount] = offset;
    }

    private byte getByte(int i) {
        return this.bytes[i];
    }

    private int getUShort(int i) {
        return ((this.bytes[i] & 0xFF) << 8) + (this.bytes[i + 1] & 0xFF);
    }

    private int getInt(int i) {
        return (this.bytes[i] << 24) + ((this.bytes[i + 1] & 0xFF) << 16) + ((this.bytes[i + 2] & 0xFF) << 8) + (this.bytes[i + 3] & 0xFF);
    }

    private long getLong(int i) {
        return ((long)this.getInt(i) << 32) + ((long)this.getInt(i + 4) & 0xFFFFFFFFL);
    }

    private float getFloat(int i) {
        return Float.intBitsToFloat(this.getInt(i));
    }

    private double getDouble(int i) {
        return Double.longBitsToDouble(this.getLong(i));
    }
}

