/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeCT;

import com.ibm.wala.shrikeCT.ClassWriter;
import java.io.UnsupportedEncodingException;

public class SourceDebugExtensionWriter
extends ClassWriter.Element {
    private final int attrID;
    private byte[] table;

    public SourceDebugExtensionWriter(ClassWriter w) {
        if (w == null) {
            throw new IllegalArgumentException("w is null");
        }
        this.attrID = w.addCPUtf8("SourceDebugExtension");
    }

    public int getSize() {
        return this.table == null ? 6 : 6 + this.table.length;
    }

    public int copyInto(byte[] buf, int offset) throws IllegalArgumentException {
        ClassWriter.setUShort(buf, offset, this.attrID);
        ClassWriter.setInt(buf, offset + 2, this.getSize() - 6);
        offset += 6;
        if (this.table != null) {
            int i = 0;
            while (i < this.table.length) {
                ClassWriter.setUByte(buf, offset, this.table[i]);
                ++offset;
                ++i;
            }
        }
        return offset;
    }

    public void setRawTable(byte[] sourceDebug) {
        if (sourceDebug == null) {
            throw new IllegalArgumentException("sourceDebug is null");
        }
        int i = 0;
        while (i < sourceDebug.length) {
            if (sourceDebug[i] < 1 || sourceDebug[i] > 65535) {
                throw new IllegalArgumentException("Invalid CP index: " + sourceDebug[i]);
            }
            ++i;
        }
        this.table = sourceDebug;
    }

    public void setDebugInfo(String sourceDebug) {
        if (sourceDebug == null) {
            throw new IllegalArgumentException("sourceDebug is null");
        }
        try {
            byte[] bytes = sourceDebug.getBytes("UTF8");
            this.setRawTable(bytes);
        }
        catch (UnsupportedEncodingException e) {
            System.err.println(e);
        }
    }
}

