/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.util.CacheReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.collections.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class AuxiliaryCache {
    private HashMap<Pair, Map<SSAOptions, Object>> dictionary = HashMapFactory.make();
    private static final int RESET_THRESHOLD = 2000;
    private int nItems = 0;

    public void wipe() {
        this.dictionary = HashMapFactory.make();
        this.nItems = 0;
    }

    private void reset() {
        HashMap<Pair, Map<SSAOptions, Object>> oldDictionary = this.dictionary;
        this.dictionary = HashMapFactory.make();
        this.nItems = 0;
        for (Map.Entry e : oldDictionary.entrySet()) {
            Map m = (Map)e.getValue();
            HashSet toRemove = HashSetFactory.make();
            for (Map.Entry e2 : m.entrySet()) {
                Object key = e2.getKey();
                Object val = e2.getValue();
                if (CacheReference.get(val) != null) continue;
                toRemove.add(key);
            }
            Iterator it2 = toRemove.iterator();
            while (it2.hasNext()) {
                m.remove(it2.next());
            }
            if (m.size() <= 0) continue;
            this.dictionary.put((Pair)e.getKey(), m);
        }
    }

    public synchronized Object find(IMethod m, Context C, SSAOptions options) {
        Pair<IMethod, Context> p = Pair.make(m, C);
        Map<SSAOptions, Object> methodMap = MapUtil.findOrCreateMap(this.dictionary, p);
        Object ref = methodMap.get(options);
        if (ref == null || CacheReference.get(ref) == null) {
            return null;
        }
        return CacheReference.get(ref);
    }

    public synchronized void cache(IMethod m, Context C, SSAOptions options, Object aux) {
        ++this.nItems;
        if (this.nItems > 2000) {
            this.reset();
        }
        Pair<IMethod, Context> p = Pair.make(m, C);
        Map<SSAOptions, Object> methodMap = MapUtil.findOrCreateMap(this.dictionary, p);
        Object ref = CacheReference.make(aux);
        methodMap.put(options, ref);
    }

    public void invalidate(IMethod method, Context C) {
        this.dictionary.remove(Pair.make(method, C));
    }
}

