/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.ssa.Value;

public class ConstantValue
implements Value {
    private final Object constant;

    public ConstantValue(Object constant) {
        this.constant = constant;
    }

    public ConstantValue(int constant) {
        this(new Integer(constant));
    }

    public ConstantValue(double constant) {
        this(new Double(constant));
    }

    public Object getValue() {
        return this.constant;
    }

    public String toString() {
        return "#" + this.constant;
    }

    public boolean isStringConstant() {
        return this.constant instanceof String;
    }

    public boolean isFalseConstant() {
        return this.constant.equals(Boolean.FALSE);
    }

    public boolean isTrueConstant() {
        return this.constant.equals(Boolean.TRUE);
    }

    public boolean isZeroConstant() {
        return this.constant instanceof Number && ((Number)this.constant).intValue() == 0;
    }

    public boolean isNullConstant() {
        return this.constant == null;
    }

    public boolean isOneConstant() {
        return this.constant instanceof Number && ((Number)this.constant).intValue() == 1;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            ConstantValue other = (ConstantValue)obj;
            if (this.constant == null) {
                return other.constant == null;
            }
            return this.constant.equals(other.constant);
        }
        return false;
    }

    public int hashCode() {
        return this.constant == null ? 74 : 91 * this.constant.hashCode();
    }

    public int getDefaultValue(SymbolTable st) {
        if (st == null) {
            throw new IllegalArgumentException("st is null");
        }
        return st.findOrCreateConstant(this.constant);
    }
}

