/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSet;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefUse {
    static final boolean DEBUG = false;
    private final SSAInstruction[] defs;
    private final MutableIntSet[] uses;
    protected final ArrayList<SSAInstruction> allInstructions = new ArrayList();
    private final IR ir;

    public DefUse(IR ir) {
        if (ir == null) {
            throw new IllegalArgumentException("ir is null");
        }
        this.ir = ir;
        this.getAllInstructions();
        this.defs = new SSAInstruction[this.getMaxValueNumber() + 1];
        this.uses = new MutableIntSet[this.getMaxValueNumber() + 1];
        Iterator<SSAInstruction> it = this.allInstructions.iterator();
        int i = 0;
        while (i < this.allInstructions.size()) {
            SSAInstruction s = it.next();
            if (s != null) {
                int j = 0;
                while (j < this.getNumberOfDefs(s)) {
                    this.defs[this.getDef((SSAInstruction)s, (int)j)] = s;
                    ++j;
                }
                j = 0;
                while (j < this.getNumberOfUses(s)) {
                    int use = this.getUse(s, j);
                    if (use != -1) {
                        if (this.uses[use] == null) {
                            this.uses[use] = IntSetUtil.make();
                        }
                        this.uses[use].add(i);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    protected int getMaxValueNumber() {
        return this.ir.getSymbolTable().getMaxValueNumber();
    }

    protected void getAllInstructions() {
        Iterator<SSAInstruction> it = this.ir.iterateAllInstructions();
        while (it.hasNext()) {
            this.allInstructions.add(it.next());
        }
    }

    protected int getDef(SSAInstruction s, int i) {
        return s.getDef(i);
    }

    protected int getUse(SSAInstruction s, int i) {
        return s.getUse(i);
    }

    protected int getNumberOfDefs(SSAInstruction s) {
        return s.getNumberOfDefs();
    }

    protected int getNumberOfUses(SSAInstruction s) {
        return s.getNumberOfUses();
    }

    public SSAInstruction getDef(int v) {
        return v < this.defs.length ? this.defs[v] : null;
    }

    public Iterator<SSAInstruction> getUses(int v) {
        if (this.uses[v] == null) {
            return EmptyIterator.instance();
        }
        return new UseIterator(this.uses[v]);
    }

    public int getNumberOfUses(int v) {
        return this.uses[v] == null ? 0 : this.uses[v].size();
    }

    public IR getIR() {
        return this.ir;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UseIterator
    implements Iterator<SSAInstruction> {
        final IntIterator it;

        UseIterator(IntSet uses) {
            this.it = uses.intIterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public SSAInstruction next() {
            return DefUse.this.allInstructions.get(this.it.next());
        }

        @Override
        public void remove() {
            Assertions.UNREACHABLE();
        }
    }
}

