/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.classLoader.ProgramCounter;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CompoundIterator;
import com.ibm.wala.util.StringStuff;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.BasicNaturalRelation;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IR {
    private final IMethod method;
    private final SSAOptions options;
    private final SSACFG cfg;
    private final SSAInstruction[] instructions;
    private final SymbolTable symbolTable;
    private final BasicNaturalRelation callSiteMapping = new BasicNaturalRelation();
    private final Map<NewSiteReference, Integer> newSiteMapping = HashMapFactory.make();
    private final Map<ProgramCounter, Integer> peiMapping = HashMapFactory.make();
    private Map<SSAInstruction, ISSABasicBlock> instruction2Block;

    protected abstract SSA2LocalMap getLocalMap();

    protected IR(IMethod method, SSAInstruction[] instructions, SymbolTable symbolTable, SSACFG cfg, SSAOptions options) {
        if (method == null) {
            throw new IllegalArgumentException("method is null");
        }
        this.method = method;
        this.instructions = instructions;
        this.symbolTable = symbolTable;
        this.cfg = cfg;
        this.options = options;
    }

    protected void setupLocationMap() {
        int i = 0;
        while (i < this.instructions.length) {
            SSAInstruction x = this.instructions[i];
            if (x != null) {
                if (x instanceof SSAAbstractInvokeInstruction) {
                    this.callSiteMapping.add(((SSAAbstractInvokeInstruction)x).getCallSite().getProgramCounter(), i);
                }
                if (x instanceof SSANewInstruction) {
                    this.newSiteMapping.put(((SSANewInstruction)x).getNewSite(), new Integer(i));
                }
                if (x.isPEI()) {
                    this.peiMapping.put(new ProgramCounter(this.cfg.getProgramCounter(i)), new Integer(i));
                }
            }
            ++i;
        }
    }

    protected abstract String instructionPosition(int var1);

    public String toString() {
        StringBuffer result = new StringBuffer(this.method.toString());
        result.append("\nCFG:\n");
        result.append(this.cfg.toString());
        result.append("Instructions:\n");
        int i = 0;
        while (i <= this.cfg.getMaxNumber()) {
            SSACFG.BasicBlock bb = this.cfg.getNode(i);
            int start = bb.getFirstInstructionIndex();
            int end = bb.getLastInstructionIndex();
            result.append("BB").append(bb.getNumber());
            if (bb instanceof SSACFG.ExceptionHandlerBasicBlock) {
                result.append("<Handler>");
            }
            result.append("\n");
            Iterator<SSAInstruction> it = bb.iteratePhis();
            while (it.hasNext()) {
                SSAPhiInstruction phi = it.next();
                if (phi == null) continue;
                result.append("           " + phi.toString(this.symbolTable)).append("\n");
            }
            if (bb instanceof SSACFG.ExceptionHandlerBasicBlock) {
                SSACFG.ExceptionHandlerBasicBlock ebb = (SSACFG.ExceptionHandlerBasicBlock)bb;
                SSAGetCaughtExceptionInstruction s = ebb.getCatchInstruction();
                if (s != null) {
                    result.append("           " + s.toString(this.symbolTable)).append("\n");
                } else {
                    result.append("            No catch instruction. Unreachable?\n");
                }
            }
            int j = start;
            while (j <= end) {
                if (this.instructions[j] != null) {
                    StringBuffer x = new StringBuffer(String.valueOf(j) + "   " + this.instructions[j].toString(this.symbolTable));
                    StringStuff.padWithSpaces(x, 45);
                    result.append(x);
                    result.append(this.instructionPosition(j));
                    result.append("\n");
                }
                ++j;
            }
            it = bb.iteratePis();
            while (it.hasNext()) {
                SSAPiInstruction pi = (SSAPiInstruction)it.next();
                if (pi == null) continue;
                result.append("           " + pi.toString(this.symbolTable)).append("\n");
            }
            ++i;
        }
        return result.toString();
    }

    public SSAInstruction[] getInstructions() {
        return this.instructions;
    }

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public SSACFG getControlFlowGraph() {
        return this.cfg;
    }

    public Iterator<? extends SSAInstruction> iteratePhis() {
        return new TwoLevelIterator(){

            @Override
            Iterator<? extends SSAInstruction> getBlockIterator(SSACFG.BasicBlock b) {
                return b.iteratePhis();
            }
        };
    }

    public Iterator<? extends SSAInstruction> iteratePis() {
        return new TwoLevelIterator(){

            @Override
            Iterator<? extends SSAInstruction> getBlockIterator(SSACFG.BasicBlock b) {
                return b.iteratePis();
            }
        };
    }

    public int[] getParameterValueNumbers() {
        return this.symbolTable.getParameterValueNumbers();
    }

    public int getParameter(int i) {
        return this.symbolTable.getParameter(i);
    }

    public TypeReference getParameterType(int i) {
        return this.method.getParameterType(i);
    }

    public int getNumberOfParameters() {
        return this.method.getNumberOfParameters();
    }

    public IMethod getMethod() {
        return this.method;
    }

    public Iterator<SSAInstruction> iterateCatchInstructions() {
        return new CatchIterator();
    }

    public void visitNormalInstructions(SSAInstruction.Visitor v) {
        Iterator<SSAInstruction> i = this.iterateNormalInstructions();
        while (i.hasNext()) {
            i.next().visit(v);
        }
    }

    public void visitAllInstructions(SSAInstruction.Visitor v) {
        Iterator<SSAInstruction> i = this.iterateAllInstructions();
        while (i.hasNext()) {
            i.next().visit(v);
        }
    }

    public Iterator<SSAInstruction> iterateNormalInstructions() {
        return new NormalIterator();
    }

    public Iterator<SSAInstruction> iterateAllInstructions() {
        return new CompoundIterator<SSAInstruction>(this.iterateNormalInstructions(), new CompoundIterator<SSAInstruction>(this.iterateCatchInstructions(), new CompoundIterator<SSAInstruction>(this.iteratePhis(), this.iteratePis())));
    }

    public SSACFG.BasicBlock getExitBlock() {
        return this.cfg.exit();
    }

    public SSAAbstractInvokeInstruction[] getCalls(CallSiteReference site) {
        if (site == null) {
            throw new IllegalArgumentException("site is null");
        }
        IntSet s = this.callSiteMapping.getRelated(site.getProgramCounter());
        SSAAbstractInvokeInstruction[] result = new SSAAbstractInvokeInstruction[s.size()];
        int index = 0;
        IntIterator it = s.intIterator();
        while (it.hasNext()) {
            int i = it.next();
            result[index++] = (SSAAbstractInvokeInstruction)this.instructions[i];
        }
        return result;
    }

    public IntSet getCallInstructionIndices(CallSiteReference site) {
        if (site == null) {
            throw new IllegalArgumentException("site is null");
        }
        return this.callSiteMapping.getRelated(site.getProgramCounter());
    }

    public SSANewInstruction getNew(NewSiteReference site) {
        Integer i = this.newSiteMapping.get(site);
        return (SSANewInstruction)this.instructions[i];
    }

    public int getNewInstructionIndex(NewSiteReference site) {
        Integer i = this.newSiteMapping.get(site);
        return i;
    }

    public SSAInstruction getPEI(ProgramCounter pc) {
        Integer i = this.peiMapping.get(pc);
        return this.instructions[i];
    }

    public Iterator<NewSiteReference> iterateNewSites() {
        return this.newSiteMapping.keySet().iterator();
    }

    public Iterator<CallSiteReference> iterateCallSites() {
        return new Iterator<CallSiteReference>(){
            private final int limit;
            private int i;
            {
                this.limit = IR.this.callSiteMapping.maxKeyValue();
                this.i = -1;
                this.advance();
            }

            private void advance() {
                while (IR.this.callSiteMapping.getRelatedCount(++this.i) == 0 && this.i <= this.limit) {
                }
            }

            @Override
            public boolean hasNext() {
                return this.i <= this.limit;
            }

            @Override
            public CallSiteReference next() {
                int index = IR.this.callSiteMapping.getRelated(this.i).max();
                this.advance();
                return ((SSAAbstractInvokeInstruction)IR.this.instructions[index]).getCallSite();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public ISSABasicBlock[] getBasicBlocksForCall(CallSiteReference site) {
        if (site == null) {
            throw new IllegalArgumentException("site is null");
        }
        IntSet s = this.callSiteMapping.getRelated(site.getProgramCounter());
        ISSABasicBlock[] result = new ISSABasicBlock[s.size()];
        int index = 0;
        IntIterator it = s.intIterator();
        while (it.hasNext()) {
            int i = it.next();
            result[index++] = this.getControlFlowGraph().getBlockForInstruction(i);
        }
        return result;
    }

    public ISSABasicBlock getBasicBlockForInstruction(SSAInstruction s) {
        if (this.instruction2Block == null) {
            this.mapInstructions2Blocks();
        }
        return this.instruction2Block.get(s);
    }

    private void mapInstructions2Blocks() {
        this.instruction2Block = HashMapFactory.make();
        for (ISSABasicBlock b : this.cfg) {
            for (IInstruction s : b) {
                this.instruction2Block.put((SSAInstruction)s, b);
            }
        }
    }

    public boolean isEmptyIR() {
        if (this.instructions == null) {
            return true;
        }
        int i = 0;
        while (i < this.instructions.length) {
            if (this.instructions[i] != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String[] getLocalNames(int index, int vn) {
        if (this.getLocalMap() == null) {
            return new String[0];
        }
        return this.getLocalMap().getLocalNames(index, vn);
    }

    public ISSABasicBlock getBasicBlockForCatch(SSAGetCaughtExceptionInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException("instruction is null");
        }
        int bb = instruction.getBasicBlockNumber();
        return this.cfg.getBasicBlock(bb);
    }

    public SSAOptions getOptions() {
        return this.options;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CatchIterator
    implements Iterator<SSAInstruction> {
        private int currentBlockIndex = 0;

        private boolean hasCatch(Object x) {
            return x instanceof SSACFG.ExceptionHandlerBasicBlock && ((SSACFG.ExceptionHandlerBasicBlock)x).getCatchInstruction() != null;
        }

        CatchIterator() {
            if (!this.hasCatch(IR.this.cfg.getNode(0))) {
                this.advanceBlock();
            }
        }

        @Override
        public boolean hasNext() {
            return this.currentBlockIndex != -1;
        }

        @Override
        public SSAInstruction next() {
            SSACFG.ExceptionHandlerBasicBlock bb = (SSACFG.ExceptionHandlerBasicBlock)IR.this.cfg.getNode(this.currentBlockIndex);
            SSAGetCaughtExceptionInstruction result = bb.getCatchInstruction();
            this.advanceBlock();
            return result;
        }

        @Override
        public void remove() {
            Assertions.UNREACHABLE();
        }

        private void advanceBlock() {
            int i = this.currentBlockIndex + 1;
            while (i < IR.this.cfg.getMaxNumber()) {
                if (this.hasCatch(IR.this.cfg.getNode(i))) {
                    this.currentBlockIndex = i;
                    return;
                }
                ++i;
            }
            this.currentBlockIndex = -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NormalIterator
    implements Iterator<SSAInstruction> {
        int nextIndex = -1;
        final SSAInstruction[] instructions;

        NormalIterator() {
            this.instructions = IR.this.getInstructions();
            this.advanceIndex(0);
        }

        private void advanceIndex(int start) {
            int i = start;
            while (i < this.instructions.length) {
                if (this.instructions[i] != null) {
                    this.nextIndex = i;
                    return;
                }
                ++i;
            }
            this.nextIndex = -1;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex != -1;
        }

        @Override
        public void remove() {
            Assertions.UNREACHABLE();
        }

        @Override
        public SSAInstruction next() {
            SSAInstruction result = this.instructions[this.nextIndex];
            this.advanceIndex(this.nextIndex + 1);
            return result;
        }
    }

    public static interface SSA2LocalMap {
        public String[] getLocalNames(int var1, int var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class TwoLevelIterator
    implements Iterator<SSAInstruction> {
        private Iterator<? extends SSAInstruction> currentBlockIterator;
        private int currentBlockIndex = 0;

        abstract Iterator<? extends SSAInstruction> getBlockIterator(SSACFG.BasicBlock var1);

        TwoLevelIterator() {
            this.currentBlockIterator = IR.this.cfg.getNode(0).iteratePhis();
            if (!this.currentBlockIterator.hasNext()) {
                this.advanceBlock();
            }
        }

        @Override
        public boolean hasNext() {
            return this.currentBlockIndex != -1;
        }

        @Override
        public SSAInstruction next() {
            SSAInstruction result = this.currentBlockIterator.next();
            if (!this.currentBlockIterator.hasNext()) {
                this.advanceBlock();
            }
            return result;
        }

        @Override
        public void remove() {
            Assertions.UNREACHABLE();
        }

        private void advanceBlock() {
            int i = this.currentBlockIndex + 1;
            while (i <= IR.this.cfg.getMaxNumber()) {
                Iterator<? extends SSAInstruction> it = this.getBlockIterator(IR.this.cfg.getNode(i));
                if (it.hasNext()) {
                    this.currentBlockIndex = i;
                    this.currentBlockIterator = it;
                    return;
                }
                ++i;
            }
            this.currentBlockIterator = null;
            this.currentBlockIndex = -1;
        }
    }
}

