/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.Exceptions;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSAArrayLengthInstruction
extends SSAInstruction {
    private final int result;
    private final int arrayref;

    public SSAArrayLengthInstruction(int result, int arrayref) {
        this.result = result;
        this.arrayref = arrayref;
    }

    @Override
    public SSAInstruction copyForSSA(int[] defs, int[] uses) throws IllegalArgumentException {
        if (defs != null && defs.length != 1) {
            throw new IllegalArgumentException();
        }
        if (uses != null && uses.length != 1) {
            throw new IllegalArgumentException();
        }
        return new SSAArrayLengthInstruction(defs == null ? this.result : defs[0], uses == null ? this.arrayref : uses[0]);
    }

    @Override
    public String toString(SymbolTable symbolTable) {
        return String.valueOf(this.getValueString(symbolTable, this.result)) + " = arraylength " + this.getValueString(symbolTable, this.arrayref);
    }

    @Override
    public void visit(SSAInstruction.IVisitor v) throws NullPointerException {
        v.visitArrayLength(this);
    }

    @Override
    public int getDef() {
        return this.result;
    }

    @Override
    public boolean hasDef() {
        return true;
    }

    @Override
    public int getDef(int i) {
        Assertions._assert(i == 0);
        return this.result;
    }

    @Override
    public int getNumberOfDefs() {
        return 1;
    }

    public int getArrayRef() {
        return this.arrayref;
    }

    @Override
    public int getNumberOfUses() {
        return 1;
    }

    @Override
    public int getUse(int j) {
        Assertions._assert(j == 0);
        return this.arrayref;
    }

    @Override
    public int hashCode() {
        return this.arrayref * 7573 + this.result * 563;
    }

    @Override
    public boolean isPEI() {
        return true;
    }

    @Override
    public boolean isFallThrough() {
        return true;
    }

    @Override
    public Collection<TypeReference> getExceptionTypes() {
        return Exceptions.getNullPointerException();
    }
}

