/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;

public abstract class SSAArrayReferenceInstruction
extends SSAInstruction {
    private final int arrayref;
    private final int index;
    private final TypeReference elementType;

    SSAArrayReferenceInstruction(int arrayref, int index, TypeReference elementType) {
        this.arrayref = arrayref;
        this.index = index;
        this.elementType = elementType;
    }

    public int getNumberOfUses() {
        return 2;
    }

    public int getUse(int j) {
        Assertions._assert(j <= 1);
        return j == 0 ? this.arrayref : this.index;
    }

    public int getArrayRef() {
        return this.arrayref;
    }

    public int getIndex() {
        return this.index;
    }

    public TypeReference getElementType() {
        return this.elementType;
    }

    public boolean typeIsPrimitive() {
        return this.elementType.isPrimitiveType();
    }

    public boolean isPEI() {
        return true;
    }

    public boolean isFallThrough() {
        return true;
    }
}

