/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAArrayReferenceInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.Exceptions;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSAArrayStoreInstruction
extends SSAArrayReferenceInstruction {
    private final int value;

    public SSAArrayStoreInstruction(int arrayref, int index, int value, TypeReference declaredType) {
        super(arrayref, index, declaredType);
        this.value = value;
    }

    @Override
    public SSAInstruction copyForSSA(int[] defs, int[] uses) {
        if (uses != null && uses.length < 3) {
            throw new IllegalArgumentException("uses.length < 3");
        }
        return new SSAArrayStoreInstruction(uses == null ? this.getArrayRef() : uses[0], uses == null ? this.getIndex() : uses[1], uses == null ? this.value : uses[2], this.getElementType());
    }

    @Override
    public String toString(SymbolTable symbolTable) {
        return "arraystore " + this.getValueString(symbolTable, this.getArrayRef()) + "[" + this.getValueString(symbolTable, this.getIndex()) + "] = " + this.getValueString(symbolTable, this.value);
    }

    @Override
    public void visit(SSAInstruction.IVisitor v) {
        if (v == null) {
            throw new IllegalArgumentException("v is null");
        }
        v.visitArrayStore(this);
    }

    @Override
    public int getNumberOfUses() {
        return 3;
    }

    @Override
    public int getNumberOfDefs() {
        return 0;
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public int getUse(int j) {
        if (j == 2) {
            return this.value;
        }
        return super.getUse(j);
    }

    @Override
    public int hashCode() {
        return 6311 * this.value ^ 2371 * this.getArrayRef() + this.getIndex();
    }

    @Override
    public Collection<TypeReference> getExceptionTypes() {
        if (this.typeIsPrimitive()) {
            return Exceptions.getArrayAccessExceptions();
        }
        return Exceptions.getAaStoreExceptions();
    }
}

