/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.shrikeBT.BinaryOpInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.Exceptions;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSABinaryOpInstruction
extends SSAInstruction {
    private final int result;
    private final int val1;
    private final int val2;
    private final BinaryOpInstruction.IOperator operator;
    private final boolean mayBeInteger;

    SSABinaryOpInstruction(BinaryOpInstruction.IOperator operator, int result, int val1, int val2, boolean mayBeInteger) {
        this.result = result;
        this.val1 = val1;
        this.val2 = val2;
        this.operator = operator;
        this.mayBeInteger = mayBeInteger;
        Assertions._assert(val1 != -1 && val2 != -1);
    }

    @Override
    public SSAInstruction copyForSSA(int[] defs, int[] uses) {
        if (uses != null && uses.length < 2) {
            throw new IllegalArgumentException("uses.length < 2");
        }
        return new SSABinaryOpInstruction(this.operator, defs == null || defs.length == 0 ? this.result : defs[0], uses == null ? this.val1 : uses[0], uses == null ? this.val2 : uses[1], this.mayBeInteger);
    }

    @Override
    public String toString(SymbolTable symbolTable) {
        return String.valueOf(this.getValueString(symbolTable, this.result)) + " = binaryop(" + this.operator + ") " + this.getValueString(symbolTable, this.val1) + " , " + this.getValueString(symbolTable, this.val2);
    }

    @Override
    public void visit(SSAInstruction.IVisitor v) throws NullPointerException {
        v.visitBinaryOp(this);
    }

    public BinaryOpInstruction.IOperator getOperator() {
        return this.operator;
    }

    @Override
    public boolean hasDef() {
        return true;
    }

    @Override
    public int getDef() {
        return this.result;
    }

    @Override
    public int getDef(int i) {
        Assertions._assert(i == 0);
        return this.result;
    }

    @Override
    public int getNumberOfDefs() {
        return 1;
    }

    @Override
    public int getNumberOfUses() {
        return 2;
    }

    @Override
    public int getUse(int j) {
        Assertions._assert(j <= 1);
        return j == 0 ? this.val1 : this.val2;
    }

    @Override
    public int hashCode() {
        return 6311 * this.result ^ 2371 * this.val1 + this.val2;
    }

    @Override
    public boolean isPEI() {
        return this.mayBeInteger && this.operator == BinaryOpInstruction.Operator.DIV || this.operator == BinaryOpInstruction.Operator.REM;
    }

    @Override
    public boolean isFallThrough() {
        return true;
    }

    @Override
    public Collection<TypeReference> getExceptionTypes() {
        if (this.isPEI()) {
            return Exceptions.getArithmeticException();
        }
        return Collections.emptySet();
    }
}

