/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.analysis.stackMachine.AbstractIntStackMachine;
import com.ibm.wala.cfg.ShrikeCFG;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.classLoader.ShrikeCTMethod;
import com.ibm.wala.shrikeBT.ArrayLengthInstruction;
import com.ibm.wala.shrikeBT.ArrayLoadInstruction;
import com.ibm.wala.shrikeBT.ArrayStoreInstruction;
import com.ibm.wala.shrikeBT.BinaryOpInstruction;
import com.ibm.wala.shrikeBT.CheckCastInstruction;
import com.ibm.wala.shrikeBT.ComparisonInstruction;
import com.ibm.wala.shrikeBT.ConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.ConstantInstruction;
import com.ibm.wala.shrikeBT.ConversionInstruction;
import com.ibm.wala.shrikeBT.GetInstruction;
import com.ibm.wala.shrikeBT.GotoInstruction;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.shrikeBT.InstanceofInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.InvokeInstruction;
import com.ibm.wala.shrikeBT.MonitorInstruction;
import com.ibm.wala.shrikeBT.NewInstruction;
import com.ibm.wala.shrikeBT.PutInstruction;
import com.ibm.wala.shrikeBT.ReturnInstruction;
import com.ibm.wala.shrikeBT.ShiftInstruction;
import com.ibm.wala.shrikeBT.StoreInstruction;
import com.ibm.wala.shrikeBT.SwitchInstruction;
import com.ibm.wala.shrikeBT.ThrowInstruction;
import com.ibm.wala.shrikeBT.UnaryOpInstruction;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.PhiValue;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAArrayLengthInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSABinaryOpInstruction;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAComparisonInstruction;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAConversionInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAGotoInstruction;
import com.ibm.wala.ssa.SSAInstanceofInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSALoadClassInstruction;
import com.ibm.wala.ssa.SSAMonitorInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SSAPiNodePolicy;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SSASwitchInstruction;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.ssa.SSAUnaryOpInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.ShrikeUtil;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.IntPair;

public class SSABuilder
extends AbstractIntStackMachine {
    private final ShrikeCTMethod method;
    private final SymbolTable symbolTable;
    private final SSA2LocalMap localMap;

    public static SSABuilder make(ShrikeCTMethod method, SSACFG cfg, ShrikeCFG scfg, SSAInstruction[] instructions, SymbolTable symbolTable, boolean buildLocalMap, SSAPiNodePolicy piNodePolicy) throws IllegalArgumentException {
        if (scfg == null) {
            throw new IllegalArgumentException("scfg == null");
        }
        return new SSABuilder(method, cfg, scfg, instructions, symbolTable, buildLocalMap, piNodePolicy);
    }

    private SSABuilder(ShrikeCTMethod method, SSACFG cfg, ShrikeCFG scfg, SSAInstruction[] instructions, SymbolTable symbolTable, boolean buildLocalMap, SSAPiNodePolicy piNodePolicy) {
        super(scfg);
        this.localMap = buildLocalMap ? new SSA2LocalMap(scfg, instructions.length, cfg.getNumberOfNodes(), this.maxLocals) : null;
        this.init(new SymbolTableMeeter(symbolTable, cfg, instructions, scfg), new SymbolicPropagator(scfg, instructions, symbolTable, this.localMap, cfg, piNodePolicy));
        this.method = method;
        this.symbolTable = symbolTable;
        Assertions._assert(cfg != null, "Null CFG");
    }

    protected void initializeVariables() {
        AbstractIntStackMachine.MachineState entryState = this.getEntryState();
        int parameterNumber = 0;
        int local = -1;
        int i = 0;
        while (i < this.method.getNumberOfParameters()) {
            ++local;
            TypeReference t = this.method.getParameterType(i);
            if (t != null) {
                int symbol = this.symbolTable.getParameter(parameterNumber++);
                entryState.setLocal(local, symbol);
                if (t.equals(TypeReference.Double) || t.equals(TypeReference.Long)) {
                    ++local;
                }
            }
            ++i;
        }
        entryState.push(this.symbolTable.newSymbol());
    }

    public void build() {
        this.solve();
        if (this.localMap != null) {
            this.localMap.finishLocalMap(this);
        }
    }

    public SSA2LocalMap getLocalMap() {
        return this.localMap;
    }

    private static class SSA2LocalMap
    implements IR.SSA2LocalMap {
        private final ShrikeCFG shrikeCFG;
        private final IntPair[] localStoreMap;
        private final int[][] block2LocalState;
        private final int maxLocals;

        SSA2LocalMap(ShrikeCFG shrikeCfg, int nInstructions, int nBlocks, int maxLocals) {
            this.shrikeCFG = shrikeCfg;
            this.localStoreMap = new IntPair[nInstructions];
            this.block2LocalState = new int[nBlocks][];
            this.maxLocals = maxLocals;
        }

        void startRange(int pc, int localNumber, int valueNumber) {
            int max = this.shrikeCFG.getMethod().getMaxLocals();
            if (localNumber >= max) {
                Assertions._assert(false, "invalid local " + localNumber + ">" + max);
            }
            this.localStoreMap[pc] = new IntPair(valueNumber, localNumber);
        }

        private void finishLocalMap(SSABuilder builder) {
            for (ShrikeCFG.BasicBlock bb : this.shrikeCFG) {
                AbstractIntStackMachine.MachineState S = builder.getIn(bb);
                int number = bb.getNumber();
                this.block2LocalState[number] = S.getLocals();
            }
        }

        public String[] getLocalNames(int index, int vn) {
            int[] localNumbers;
            block6: {
                block5: {
                    if (this.shrikeCFG.getMethod().hasLocalVariableTable()) break block5;
                    return null;
                }
                localNumbers = this.findLocalsForValueNumber(index, vn);
                if (localNumbers != null) break block6;
                return null;
            }
            try {
                ShrikeCTMethod m = (ShrikeCTMethod)this.shrikeCFG.getMethod();
                String[] result = new String[localNumbers.length];
                int i = 0;
                while (i < localNumbers.length) {
                    result[i] = m.getLocalVariableName(m.getBytecodeIndex(index), localNumbers[i]);
                    ++i;
                }
                return result;
            }
            catch (Exception e) {
                e.printStackTrace();
                Assertions.UNREACHABLE();
                return null;
            }
        }

        private int[] findLocalsForValueNumber(int pc, int vn) {
            ShrikeCFG.BasicBlock bb = this.shrikeCFG.getBlockForInstruction(pc);
            int firstInstruction = bb.getFirstInstructionIndex();
            int[] locals = this.block2LocalState[bb.getNumber()];
            if (locals == null) {
                locals = this.allocateNewLocalsArray();
            }
            int i = firstInstruction;
            while (i <= pc) {
                if (this.localStoreMap[i] != null) {
                    IntPair p = this.localStoreMap[i];
                    locals[p.getY()] = p.getX();
                }
                ++i;
            }
            return this.extractIndices(locals, vn);
        }

        public int[] allocateNewLocalsArray() {
            int[] result = new int[this.maxLocals];
            int i = 0;
            while (i < this.maxLocals) {
                result[i] = -1;
                ++i;
            }
            return result;
        }

        private int[] extractIndices(int[] x, int y) {
            int count = 0;
            int i = 0;
            while (i < x.length) {
                if (x[i] == y) {
                    ++count;
                }
                ++i;
            }
            if (count == 0) {
                return null;
            }
            int[] result = new int[count];
            int j = 0;
            int i2 = 0;
            while (i2 < x.length) {
                if (x[i2] == y) {
                    result[j++] = i2;
                }
                ++i2;
            }
            return result;
        }
    }

    private static class SymbolTableMeeter
    implements AbstractIntStackMachine.Meeter {
        final SSACFG cfg;
        final SSAInstruction[] instructions;
        final SymbolTable symbolTable;
        final ShrikeCFG shrikeCFG;

        SymbolTableMeeter(SymbolTable symbolTable, SSACFG cfg, SSAInstruction[] instructions, ShrikeCFG shrikeCFG) {
            this.cfg = cfg;
            this.instructions = instructions;
            this.symbolTable = symbolTable;
            this.shrikeCFG = shrikeCFG;
        }

        public int meetStack(int slot, int[] rhs, ShrikeCFG.BasicBlock bb) {
            int result;
            Assertions._assert(bb != null, "null basic block");
            if (bb.isExitBlock()) {
                return -1;
            }
            if (this.allTheSame(rhs)) {
                int i = 0;
                while (i < rhs.length) {
                    if (rhs[i] != -1) {
                        return rhs[i];
                    }
                    ++i;
                }
                return -1;
            }
            SSACFG.BasicBlock newBB = this.cfg.getNode(this.shrikeCFG.getNumber(bb));
            SSAPhiInstruction phi = newBB.getPhiForStackSlot(slot);
            if (phi == null) {
                result = this.symbolTable.newPhi(rhs);
                PhiValue v = this.symbolTable.getPhiValue(result);
                phi = v.getPhiInstruction();
                newBB.addPhiForStackSlot(slot, phi);
            } else {
                result = phi.getDef();
                phi.setValues((int[])rhs.clone());
            }
            return result;
        }

        public int meetLocal(int n, int[] rhs, ShrikeCFG.BasicBlock bb) {
            int result;
            if (this.allTheSame(rhs)) {
                int i = 0;
                while (i < rhs.length) {
                    if (rhs[i] != -1) {
                        return rhs[i];
                    }
                    ++i;
                }
                return -1;
            }
            SSACFG.BasicBlock newBB = this.cfg.getNode(this.shrikeCFG.getNumber(bb));
            if (bb.isExitBlock()) {
                return -1;
            }
            SSAPhiInstruction phi = newBB.getPhiForLocal(n);
            if (phi == null) {
                result = this.symbolTable.newPhi(rhs);
                PhiValue v = this.symbolTable.getPhiValue(result);
                phi = v.getPhiInstruction();
                newBB.addPhiForLocal(n, phi);
            } else {
                result = phi.getDef();
                phi.setValues((int[])rhs.clone());
            }
            return result;
        }

        private boolean allTheSame(int[] rhs) {
            int x = -1;
            int i = 0;
            i = 0;
            while (i < rhs.length) {
                if (rhs[i] != -1) {
                    x = rhs[i];
                    break;
                }
                ++i;
            }
            ++i;
            while (i < rhs.length) {
                if (rhs[i] != x && rhs[i] != -1) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public int meetStackAtCatchBlock(ShrikeCFG.BasicBlock bb) {
            int exceptionValue;
            int bbNumber = this.shrikeCFG.getNumber(bb);
            SSACFG.ExceptionHandlerBasicBlock newBB = (SSACFG.ExceptionHandlerBasicBlock)this.cfg.getNode(bbNumber);
            SSAGetCaughtExceptionInstruction s = newBB.getCatchInstruction();
            if (s == null) {
                exceptionValue = this.symbolTable.newSymbol();
                s = new SSAGetCaughtExceptionInstruction(bbNumber, exceptionValue);
                newBB.setCatchInstruction(s);
            } else {
                exceptionValue = s.getException();
            }
            return exceptionValue;
        }
    }

    private static class SymbolicPropagator
    extends AbstractIntStackMachine.BasicStackFlowProvider {
        final SSAInstruction[] instructions;
        final SymbolTable symbolTable;
        final ShrikeCFG shrikeCFG;
        final SSACFG cfg;
        final ClassLoaderReference loader;
        private SSAInstruction[] creators;
        final SSA2LocalMap localMap;
        final SSAPiNodePolicy piNodePolicy;

        public SymbolicPropagator(ShrikeCFG shrikeCFG, SSAInstruction[] instructions, SymbolTable symbolTable, SSA2LocalMap localMap, SSACFG cfg, SSAPiNodePolicy piNodePolicy) {
            super(shrikeCFG);
            this.piNodePolicy = piNodePolicy;
            this.cfg = cfg;
            this.creators = new SSAInstruction[0];
            this.shrikeCFG = shrikeCFG;
            this.instructions = instructions;
            this.symbolTable = symbolTable;
            this.loader = shrikeCFG.getMethod().getDeclaringClass().getClassLoader().getReference();
            this.localMap = localMap;
            this.init(new NodeVisitor(), new EdgeVisitor());
        }

        public boolean needsEdgeFlow() {
            return this.piNodePolicy != null;
        }

        private void emitInstruction(SSAInstruction s) {
            this.instructions[this.getCurrentInstructionIndex()] = s;
            int i = 0;
            while (i < s.getNumberOfDefs()) {
                if (this.creators.length < s.getDef(i) + 1) {
                    SSAInstruction[] arr = new SSAInstruction[2 * s.getDef(i)];
                    System.arraycopy(this.creators, 0, arr, 0, this.creators.length);
                    this.creators = arr;
                }
                this.creators[s.getDef((int)i)] = s;
                ++i;
            }
        }

        private SSAInstruction getCurrentInstruction() {
            return this.instructions[this.getCurrentInstructionIndex()];
        }

        private int reuseOrCreateDef() {
            if (this.getCurrentInstruction() == null) {
                return this.symbolTable.newSymbol();
            }
            return this.getCurrentInstruction().getDef();
        }

        private int reuseOrCreateException() {
            if (this.getCurrentInstruction() != null) {
                Assertions._assert(this.getCurrentInstruction() instanceof SSAInvokeInstruction);
            }
            if (this.getCurrentInstruction() == null) {
                return this.symbolTable.newSymbol();
            }
            SSAInvokeInstruction s = (SSAInvokeInstruction)this.getCurrentInstruction();
            return s.getException();
        }

        private void reuseOrCreatePi(SSAInstruction piCause, int ref) {
            int n = this.getCurrentInstructionIndex();
            SSACFG.BasicBlock bb = this.cfg.getBlockForInstruction(n);
            ShrikeCFG.BasicBlock path = this.getCurrentSuccessor();
            int outNum = this.shrikeCFG.getNumber(path);
            SSAPiInstruction pi = bb.getPiForRefAndPath(ref, path);
            if (pi == null) {
                pi = new SSAPiInstruction(this.symbolTable.newSymbol(), ref, bb.getNumber(), outNum, piCause);
                bb.addPiForRefAndPath(ref, path, pi);
            }
            this.workingState.replaceValue(ref, pi.getDef());
        }

        private void maybeInsertPi(SSAAbstractInvokeInstruction call) {
            Pair<Integer, SSAInstruction> pi;
            if (this.piNodePolicy != null && (pi = this.piNodePolicy.getPi(call, this.symbolTable)) != null) {
                this.reuseOrCreatePi((SSAInstruction)pi.snd, (Integer)pi.fst);
            }
        }

        private void maybeInsertPi(SSAConditionalBranchInstruction cond) {
            Pair<Integer, SSAInstruction> pi;
            if (this.piNodePolicy != null && (pi = this.piNodePolicy.getPi(cond, this.getDef(cond.getUse(0)), this.getDef(cond.getUse(1)), this.symbolTable)) != null) {
                this.reuseOrCreatePi((SSAInstruction)pi.snd, (Integer)pi.fst);
            }
        }

        private SSAInstruction getDef(int vn) {
            if (vn < this.creators.length) {
                return this.creators[vn];
            }
            return null;
        }

        public Instruction[] getInstructions() {
            try {
                return ((ShrikeCTMethod)this.shrikeCFG.getMethod()).getInstructions();
            }
            catch (InvalidClassFileException e) {
                e.printStackTrace();
                Assertions.UNREACHABLE();
                return null;
            }
        }

        class EdgeVisitor
        extends Instruction.Visitor {
            EdgeVisitor() {
            }

            public void visitInvoke(InvokeInstruction instruction) {
                SymbolicPropagator.this.maybeInsertPi((SSAAbstractInvokeInstruction)SymbolicPropagator.this.getCurrentInstruction());
            }

            public void visitConditionalBranch(ConditionalBranchInstruction instruction) {
                SymbolicPropagator.this.maybeInsertPi((SSAConditionalBranchInstruction)SymbolicPropagator.this.getCurrentInstruction());
            }
        }

        class NodeVisitor
        extends AbstractIntStackMachine.BasicStackFlowProvider.BasicStackMachineVisitor {
            NodeVisitor() {
            }

            public void visitArrayLength(ArrayLengthInstruction instruction) {
                int arrayRef = SymbolicPropagator.this.workingState.pop();
                int length = SymbolicPropagator.this.reuseOrCreateDef();
                SymbolicPropagator.this.workingState.push(length);
                SymbolicPropagator.this.emitInstruction(new SSAArrayLengthInstruction(length, arrayRef));
            }

            public void visitArrayLoad(ArrayLoadInstruction instruction) {
                int index = SymbolicPropagator.this.workingState.pop();
                int arrayRef = SymbolicPropagator.this.workingState.pop();
                int result = SymbolicPropagator.this.reuseOrCreateDef();
                SymbolicPropagator.this.workingState.push(result);
                TypeReference t = ShrikeUtil.makeTypeReference(SymbolicPropagator.this.loader, instruction.getType());
                SymbolicPropagator.this.emitInstruction(new SSAArrayLoadInstruction(result, arrayRef, index, t));
            }

            public void visitArrayStore(ArrayStoreInstruction instruction) {
                int value = SymbolicPropagator.this.workingState.pop();
                int index = SymbolicPropagator.this.workingState.pop();
                int arrayRef = SymbolicPropagator.this.workingState.pop();
                TypeReference t = ShrikeUtil.makeTypeReference(SymbolicPropagator.this.loader, instruction.getType());
                SymbolicPropagator.this.emitInstruction(new SSAArrayStoreInstruction(arrayRef, index, value, t));
            }

            public void visitBinaryOp(BinaryOpInstruction instruction) {
                int val2 = SymbolicPropagator.this.workingState.pop();
                int val1 = SymbolicPropagator.this.workingState.pop();
                int result = SymbolicPropagator.this.reuseOrCreateDef();
                SymbolicPropagator.this.workingState.push(result);
                boolean isFloat = instruction.getType().equals("D") || instruction.getType().equals("F");
                SymbolicPropagator.this.emitInstruction(new SSABinaryOpInstruction(instruction.getOperator(), result, val1, val2, !isFloat));
            }

            public void visitCheckCast(CheckCastInstruction instruction) {
                int val = SymbolicPropagator.this.workingState.pop();
                int result = SymbolicPropagator.this.reuseOrCreateDef();
                SymbolicPropagator.this.workingState.push(result);
                TypeReference t = ShrikeUtil.makeTypeReference(SymbolicPropagator.this.loader, instruction.getType());
                SymbolicPropagator.this.emitInstruction(new SSACheckCastInstruction(result, val, t));
            }

            public void visitComparison(ComparisonInstruction instruction) {
                int val2 = SymbolicPropagator.this.workingState.pop();
                int val1 = SymbolicPropagator.this.workingState.pop();
                int result = SymbolicPropagator.this.reuseOrCreateDef();
                SymbolicPropagator.this.workingState.push(result);
                SymbolicPropagator.this.emitInstruction(new SSAComparisonInstruction(instruction.getOpcode(), result, val1, val2));
            }

            public void visitConditionalBranch(ConditionalBranchInstruction instruction) {
                int val2 = SymbolicPropagator.this.workingState.pop();
                int val1 = SymbolicPropagator.this.workingState.pop();
                TypeReference t = ShrikeUtil.makeTypeReference(SymbolicPropagator.this.loader, instruction.getType());
                SymbolicPropagator.this.emitInstruction(new SSAConditionalBranchInstruction(instruction.getOperator(), t, val1, val2));
            }

            public void visitConstant(ConstantInstruction instruction) {
                TypeReference type = ShrikeUtil.makeTypeReference(ClassLoaderReference.Primordial, instruction.getType());
                int symbol = 0;
                if (type == TypeReference.Null) {
                    symbol = SymbolicPropagator.this.symbolTable.getNullConstant();
                } else if (type == TypeReference.Int) {
                    Integer value = (Integer)instruction.getValue();
                    symbol = SymbolicPropagator.this.symbolTable.getConstant(value);
                } else if (type == TypeReference.Long) {
                    Long value = (Long)instruction.getValue();
                    symbol = SymbolicPropagator.this.symbolTable.getConstant(value);
                } else if (type == TypeReference.Float) {
                    Float value = (Float)instruction.getValue();
                    symbol = SymbolicPropagator.this.symbolTable.getConstant(value.floatValue());
                } else if (type == TypeReference.Double) {
                    Double value = (Double)instruction.getValue();
                    symbol = SymbolicPropagator.this.symbolTable.getConstant(value);
                } else if (type == TypeReference.JavaLangString) {
                    String value = (String)instruction.getValue();
                    symbol = SymbolicPropagator.this.symbolTable.getConstant(value);
                } else if (type == TypeReference.JavaLangClass) {
                    TypeReference rval = ShrikeUtil.makeTypeReference(ClassLoaderReference.Primordial, (String)instruction.getValue());
                    symbol = SymbolicPropagator.this.reuseOrCreateDef();
                    SymbolicPropagator.this.emitInstruction(new SSALoadClassInstruction(symbol, rval));
                } else {
                    Assertions.UNREACHABLE("unexpected " + type);
                }
                SymbolicPropagator.this.workingState.push(symbol);
            }

            public void visitConversion(ConversionInstruction instruction) {
                int val = SymbolicPropagator.this.workingState.pop();
                int result = SymbolicPropagator.this.reuseOrCreateDef();
                SymbolicPropagator.this.workingState.push(result);
                TypeReference fromType = ShrikeUtil.makeTypeReference(ClassLoaderReference.Primordial, instruction.getFromType());
                TypeReference toType = ShrikeUtil.makeTypeReference(ClassLoaderReference.Primordial, instruction.getToType());
                SymbolicPropagator.this.emitInstruction(new SSAConversionInstruction(result, val, fromType, toType));
            }

            public void visitGet(GetInstruction instruction) {
                int result = SymbolicPropagator.this.reuseOrCreateDef();
                if (instruction.isStatic()) {
                    FieldReference f = FieldReference.findOrCreate(SymbolicPropagator.this.loader, instruction.getClassType(), instruction.getFieldName(), instruction.getFieldType());
                    SymbolicPropagator.this.emitInstruction(new SSAGetInstruction(result, f));
                } else {
                    int ref = SymbolicPropagator.this.workingState.pop();
                    FieldReference f = FieldReference.findOrCreate(SymbolicPropagator.this.loader, instruction.getClassType(), instruction.getFieldName(), instruction.getFieldType());
                    SymbolicPropagator.this.emitInstruction(new SSAGetInstruction(result, ref, f));
                }
                SymbolicPropagator.this.workingState.push(result);
            }

            public void visitGoto(GotoInstruction instruction) {
                SymbolicPropagator.this.emitInstruction(new SSAGotoInstruction());
            }

            public void visitInstanceof(InstanceofInstruction instruction) {
                int ref = SymbolicPropagator.this.workingState.pop();
                int result = SymbolicPropagator.this.reuseOrCreateDef();
                SymbolicPropagator.this.workingState.push(result);
                TypeReference t = ShrikeUtil.makeTypeReference(SymbolicPropagator.this.loader, instruction.getType());
                SymbolicPropagator.this.emitInstruction(new SSAInstanceofInstruction(result, ref, t));
            }

            public void visitInvoke(InvokeInstruction instruction) {
                int n = instruction.getPoppedCount();
                int[] params = new int[n];
                int i = n - 1;
                while (i >= 0) {
                    params[i] = SymbolicPropagator.this.workingState.pop();
                    --i;
                }
                MethodReference m = MethodReference.findOrCreate(SymbolicPropagator.this.loader, instruction.getClassType(), instruction.getMethodName(), instruction.getMethodSignature());
                IInvokeInstruction.Dispatch code = ShrikeUtil.getInvocationCode(instruction);
                CallSiteReference site = CallSiteReference.make(SymbolicPropagator.this.getCurrentProgramCounter(), m, code);
                int exc = SymbolicPropagator.this.reuseOrCreateException();
                if (instruction.getPushedWordSize() > 0) {
                    int result = SymbolicPropagator.this.reuseOrCreateDef();
                    SymbolicPropagator.this.workingState.push(result);
                    SymbolicPropagator.this.emitInstruction(new SSAInvokeInstruction(result, params, exc, site));
                } else {
                    SymbolicPropagator.this.emitInstruction(new SSAInvokeInstruction(params, exc, site));
                }
            }

            public void visitLocalStore(StoreInstruction instruction) {
                if (SymbolicPropagator.this.localMap != null) {
                    SymbolicPropagator.this.localMap.startRange(SymbolicPropagator.this.getCurrentInstructionIndex(), instruction.getVarIndex(), SymbolicPropagator.this.workingState.peek());
                }
                super.visitLocalStore(instruction);
            }

            public void visitMonitor(MonitorInstruction instruction) {
                int ref = SymbolicPropagator.this.workingState.pop();
                SymbolicPropagator.this.emitInstruction(new SSAMonitorInstruction(ref, instruction.isEnter()));
            }

            public void visitNew(NewInstruction instruction) {
                int result = SymbolicPropagator.this.reuseOrCreateDef();
                TypeReference t = ShrikeUtil.makeTypeReference(SymbolicPropagator.this.loader, instruction.getType());
                NewSiteReference ref = NewSiteReference.make(SymbolicPropagator.this.getCurrentProgramCounter(), t);
                if (t.isArrayType()) {
                    int[] sizes = new int[t.getDimensionality()];
                    int i = 0;
                    while (i < instruction.getArrayBoundsCount()) {
                        sizes[i] = SymbolicPropagator.this.workingState.pop();
                        ++i;
                    }
                    i = instruction.getArrayBoundsCount();
                    while (i < sizes.length) {
                        sizes[i] = SymbolicPropagator.this.symbolTable.getConstant(0);
                        ++i;
                    }
                    SymbolicPropagator.this.emitInstruction(new SSANewInstruction(result, ref, sizes));
                } else {
                    SymbolicPropagator.this.emitInstruction(new SSANewInstruction(result, ref));
                    this.popN(instruction);
                }
                SymbolicPropagator.this.workingState.push(result);
            }

            public void visitPut(PutInstruction instruction) {
                int value = SymbolicPropagator.this.workingState.pop();
                if (instruction.isStatic()) {
                    FieldReference f = FieldReference.findOrCreate(SymbolicPropagator.this.loader, instruction.getClassType(), instruction.getFieldName(), instruction.getFieldType());
                    SymbolicPropagator.this.emitInstruction(new SSAPutInstruction(value, f));
                } else {
                    int ref = SymbolicPropagator.this.workingState.pop();
                    FieldReference f = FieldReference.findOrCreate(SymbolicPropagator.this.loader, instruction.getClassType(), instruction.getFieldName(), instruction.getFieldType());
                    SymbolicPropagator.this.emitInstruction(new SSAPutInstruction(ref, value, f));
                }
            }

            public void visitReturn(ReturnInstruction instruction) {
                if (instruction.getPoppedCount() == 1) {
                    int result = SymbolicPropagator.this.workingState.pop();
                    TypeReference t = ShrikeUtil.makeTypeReference(SymbolicPropagator.this.loader, instruction.getType());
                    SymbolicPropagator.this.emitInstruction(new SSAReturnInstruction(result, t.isPrimitiveType()));
                } else {
                    SymbolicPropagator.this.emitInstruction(new SSAReturnInstruction());
                }
            }

            public void visitShift(ShiftInstruction instruction) {
                int val2 = SymbolicPropagator.this.workingState.pop();
                int val1 = SymbolicPropagator.this.workingState.pop();
                int result = SymbolicPropagator.this.reuseOrCreateDef();
                SymbolicPropagator.this.workingState.push(result);
                SymbolicPropagator.this.emitInstruction(new SSABinaryOpInstruction(instruction.getOperator(), result, val1, val2, true));
            }

            public void visitSwitch(SwitchInstruction instruction) {
                int val = SymbolicPropagator.this.workingState.pop();
                SymbolicPropagator.this.emitInstruction(new SSASwitchInstruction(val, instruction.getDefaultLabel(), instruction.getCasesAndLabels()));
            }

            public void visitThrow(ThrowInstruction instruction) {
                int exception = SymbolicPropagator.this.workingState.pop();
                SymbolicPropagator.this.workingState.clearStack();
                SymbolicPropagator.this.workingState.push(exception);
                SymbolicPropagator.this.emitInstruction(new SSAThrowInstruction(exception));
            }

            public void visitUnaryOp(UnaryOpInstruction instruction) {
                int val = SymbolicPropagator.this.workingState.pop();
                int result = SymbolicPropagator.this.reuseOrCreateDef();
                SymbolicPropagator.this.workingState.push(result);
                SymbolicPropagator.this.emitInstruction(new SSAUnaryOpInstruction(instruction.getOperator(), result, val));
            }
        }
    }
}

