/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ssa.AuxiliaryCache;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.IRFactory;
import com.ibm.wala.ssa.SSAOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSACache {
    private static final boolean DISABLE = false;
    private final IRFactory<IMethod> factory;
    private final AuxiliaryCache irCache = new AuxiliaryCache();
    private final AuxiliaryCache duCache = new AuxiliaryCache();

    public SSACache(IRFactory<IMethod> factory) {
        this.factory = factory;
    }

    public synchronized IR findOrCreateIR(IMethod m, Context C, SSAOptions options) {
        if (m == null) {
            throw new IllegalArgumentException("m is null");
        }
        if (m.isAbstract() || m.isNative()) {
            return null;
        }
        IR ir = (IR)this.irCache.find(m, C, options);
        if (ir == null) {
            ir = this.factory.makeIR(m, C, options);
            this.irCache.cache(m, C, options, ir);
        }
        return ir;
    }

    public synchronized DefUse findOrCreateDU(IMethod m, Context C, SSAOptions options) {
        if (m == null) {
            throw new IllegalArgumentException("m is null");
        }
        if (m.isAbstract() || m.isNative()) {
            return null;
        }
        DefUse du = (DefUse)this.duCache.find(m, C, options);
        if (du == null) {
            IR ir = this.findOrCreateIR(m, C, options);
            du = new DefUse(ir);
            this.duCache.cache(m, C, options, du);
        }
        return du;
    }

    public synchronized DefUse findOrCreateDU(IR ir, Context C) {
        if (ir == null) {
            throw new IllegalArgumentException("ir is null");
        }
        DefUse du = (DefUse)this.duCache.find(ir.getMethod(), C, ir.getOptions());
        if (du == null) {
            du = new DefUse(ir);
            this.duCache.cache(ir.getMethod(), C, ir.getOptions(), du);
        }
        return du;
    }

    public void wipe() {
        this.irCache.wipe();
        this.duCache.wipe();
    }

    public void invalidateIR(IMethod method, Context C) {
        this.irCache.invalidate(method, C);
    }

    public void invalidateDU(IMethod method, Context C) {
        this.duCache.invalidate(method, C);
    }

    public void invalidate(IMethod method, Context C) {
        this.invalidateIR(method, C);
        this.invalidateDU(method, C);
    }
}

