/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.Exceptions;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSACheckCastInstruction
extends SSAInstruction {
    private final int result;
    private final int val;
    private final TypeReference declaredResultType;

    SSACheckCastInstruction(int result, int val, TypeReference type) {
        this.result = result;
        this.val = val;
        this.declaredResultType = type;
    }

    @Override
    public SSAInstruction copyForSSA(int[] defs, int[] uses) {
        if (defs != null && defs.length == 0) {
            throw new IllegalArgumentException("(defs != null) and (defs.length == 0)");
        }
        if (uses != null && uses.length == 0) {
            throw new IllegalArgumentException("(uses != null) and (uses.length == 0)");
        }
        return new SSACheckCastInstruction(defs == null ? this.result : defs[0], uses == null ? this.val : uses[0], this.declaredResultType);
    }

    @Override
    public String toString(SymbolTable symbolTable) {
        return String.valueOf(this.getValueString(symbolTable, this.result)) + " = checkcast " + this.declaredResultType.getName() + " " + this.getValueString(symbolTable, this.val);
    }

    @Override
    public void visit(SSAInstruction.IVisitor v) {
        if (v == null) {
            throw new IllegalArgumentException("v is null");
        }
        v.visitCheckCast(this);
    }

    @Override
    public boolean hasDef() {
        return true;
    }

    @Override
    public int getDef() {
        return this.result;
    }

    @Override
    public int getDef(int i) {
        Assertions._assert(i == 0);
        return this.result;
    }

    @Override
    public int getNumberOfDefs() {
        return 1;
    }

    @Override
    public int getNumberOfUses() {
        return 1;
    }

    @Override
    public int getUse(int j) {
        Assertions._assert(j == 0);
        return this.val;
    }

    public TypeReference getDeclaredResultType() {
        return this.declaredResultType;
    }

    public int getResult() {
        return this.result;
    }

    public int getVal() {
        return this.val;
    }

    @Override
    public int hashCode() {
        return this.result * 7529 + this.val;
    }

    @Override
    public boolean isPEI() {
        return true;
    }

    @Override
    public boolean isFallThrough() {
        return true;
    }

    @Override
    public Collection<TypeReference> getExceptionTypes() {
        return Exceptions.getClassCastException();
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " " + this.declaredResultType;
    }
}

