/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSAConversionInstruction
extends SSAInstruction {
    private final int result;
    private final int val;
    private final TypeReference fromType;
    private final TypeReference toType;

    SSAConversionInstruction(int result, int val, TypeReference fromType, TypeReference toType) {
        this.result = result;
        this.val = val;
        this.fromType = fromType;
        this.toType = toType;
    }

    @Override
    public SSAInstruction copyForSSA(int[] defs, int[] uses) throws IllegalArgumentException {
        if (uses != null && uses.length == 0) {
            throw new IllegalArgumentException("(uses != null) and (uses.length == 0)");
        }
        return new SSAConversionInstruction(defs == null || defs.length == 0 ? this.result : defs[0], uses == null ? this.val : uses[0], this.fromType, this.toType);
    }

    @Override
    public String toString(SymbolTable symbolTable) {
        return String.valueOf(this.getValueString(symbolTable, this.result)) + " = conversion(" + this.toType.getName() + ") " + this.getValueString(symbolTable, this.val);
    }

    @Override
    public void visit(SSAInstruction.IVisitor v) throws NullPointerException {
        v.visitConversion(this);
    }

    @Override
    public boolean hasDef() {
        return true;
    }

    @Override
    public int getDef() {
        return this.result;
    }

    @Override
    public int getDef(int i) {
        Assertions._assert(i == 0);
        return this.result;
    }

    @Override
    public int getNumberOfUses() {
        return 1;
    }

    @Override
    public int getNumberOfDefs() {
        return 1;
    }

    public TypeReference getToType() {
        return this.toType;
    }

    public TypeReference getFromType() {
        return this.fromType;
    }

    @Override
    public int getUse(int j) {
        Assertions._assert(j == 0);
        return this.val;
    }

    @Override
    public int hashCode() {
        return 6311 * this.result ^ this.val;
    }

    @Override
    public boolean isFallThrough() {
        return true;
    }

    @Override
    public Collection<TypeReference> getExceptionTypes() {
        return Collections.emptySet();
    }
}

