/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.Exceptions;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SSAFieldAccessInstruction
extends SSAInstruction {
    private final FieldReference field;
    private final int ref;

    protected SSAFieldAccessInstruction(FieldReference field, int ref) throws IllegalArgumentException {
        this.field = field;
        this.ref = ref;
        if (field == null) {
            throw new IllegalArgumentException("field cannot be null");
        }
    }

    public TypeReference getDeclaredFieldType() {
        return this.field.getFieldType();
    }

    public FieldReference getDeclaredField() {
        return this.field;
    }

    public int getRef() {
        return this.ref;
    }

    public boolean isStatic() {
        return this.ref == -1;
    }

    @Override
    public boolean isPEI() {
        return !this.isStatic();
    }

    @Override
    public Collection<TypeReference> getExceptionTypes() {
        Collection<TypeReference> empty = Collections.emptySet();
        return this.isStatic() ? empty : Exceptions.getNullPointerException();
    }
}

