/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSAGetCaughtExceptionInstruction
extends SSAInstruction {
    private final int exceptionValueNumber;
    private final int bbNumber;

    SSAGetCaughtExceptionInstruction(int bbNumber, int exceptionValueNumber) {
        this.exceptionValueNumber = exceptionValueNumber;
        this.bbNumber = bbNumber;
    }

    @Override
    public SSAInstruction copyForSSA(int[] defs, int[] uses) {
        return new SSAGetCaughtExceptionInstruction(this.bbNumber, defs == null || defs.length == 0 ? this.exceptionValueNumber : defs[0]);
    }

    @Override
    public String toString(SymbolTable symbolTable) {
        StringBuffer s = new StringBuffer();
        s.append(this.getValueString(symbolTable, this.exceptionValueNumber)).append(" = getCaughtException ");
        return s.toString();
    }

    @Override
    public void visit(SSAInstruction.IVisitor v) {
        if (v == null) {
            throw new IllegalArgumentException("v is null");
        }
        v.visitGetCaughtException(this);
    }

    public int getException() {
        return this.exceptionValueNumber;
    }

    @Override
    public boolean hasDef() {
        return true;
    }

    @Override
    public int getDef() {
        return this.exceptionValueNumber;
    }

    @Override
    public int getDef(int i) {
        Assertions._assert(i == 0);
        return this.exceptionValueNumber;
    }

    @Override
    public int getNumberOfDefs() {
        return 1;
    }

    public int getBasicBlockNumber() {
        return this.bbNumber;
    }

    @Override
    public int hashCode() {
        return 2243 * this.exceptionValueNumber;
    }

    @Override
    public boolean isFallThrough() {
        return true;
    }

    @Override
    public Collection<TypeReference> getExceptionTypes() {
        return null;
    }
}

