/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAFieldAccessInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.util.debug.Assertions;

public class SSAGetInstruction
extends SSAFieldAccessInstruction {
    private final int result;

    public SSAGetInstruction(int result, int ref, FieldReference field) {
        super(field, ref);
        this.result = result;
    }

    public SSAGetInstruction(int result, FieldReference field) {
        super(field, -1);
        this.result = result;
    }

    public SSAInstruction copyForSSA(int[] defs, int[] uses) {
        if (this.isStatic()) {
            return new SSAGetInstruction(defs == null || defs.length == 0 ? this.result : defs[0], this.getDeclaredField());
        }
        return new SSAGetInstruction(defs == null || defs.length == 0 ? this.result : defs[0], uses == null ? this.getRef() : uses[0], this.getDeclaredField());
    }

    public String toString(SymbolTable symbolTable) {
        if (this.isStatic()) {
            return String.valueOf(this.getValueString(symbolTable, this.result)) + " = getstatic " + this.getDeclaredField();
        }
        return String.valueOf(this.getValueString(symbolTable, this.result)) + " = getfield " + this.getDeclaredField() + " " + this.getValueString(symbolTable, this.getRef());
    }

    public void visit(SSAInstruction.IVisitor v) throws NullPointerException {
        v.visitGet(this);
    }

    public boolean hasDef() {
        return true;
    }

    public int getDef() {
        return this.result;
    }

    public int getDef(int i) {
        Assertions._assert(i == 0);
        return this.result;
    }

    public int getNumberOfDefs() {
        return 1;
    }

    public int getNumberOfUses() {
        return this.isStatic() ? 0 : 1;
    }

    public int getUse(int j) {
        Assertions._assert(j == 0 && this.getRef() != -1);
        return this.getRef();
    }

    public int hashCode() {
        return this.result * 2371 + 6521;
    }

    public boolean isFallThrough() {
        return true;
    }
}

