/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.Exceptions;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSAInvokeInstruction
extends SSAAbstractInvokeInstruction {
    private final int result;
    private final int[] params;

    public SSAInvokeInstruction(int result, int[] params, int exception, CallSiteReference site) {
        super(exception, site);
        this.result = result;
        this.params = params;
        SSAInvokeInstruction.assertParamsKosher(result, params, site);
    }

    public SSAInvokeInstruction(int[] params, int exception, CallSiteReference site) {
        this(-1, params, exception, site);
    }

    @Override
    public SSAInstruction copyForSSA(int[] defs, int[] uses) {
        return new SSAInvokeInstruction(defs == null || this.result == -1 ? this.result : defs[0], uses == null ? this.params : uses, defs == null ? this.exception : defs[this.result == -1 ? 0 : 1], this.site);
    }

    public static void assertParamsKosher(int result, int[] params, CallSiteReference site) throws IllegalArgumentException {
        if (site == null) {
            throw new IllegalArgumentException("site cannot be null");
        }
        if (site.getDeclaredTarget().getReturnType().equals(TypeReference.Void) && result != -1) {
            Assertions._assert(result == -1, "bogus call to " + site);
        }
        int nExpected = 0;
        if (!site.isStatic()) {
            ++nExpected;
        }
        if ((nExpected += site.getDeclaredTarget().getNumberOfParameters()) > 0) {
            if (params == null) {
                Assertions._assert(params != null, "null params for " + site);
            }
            if (params.length != nExpected) {
                Assertions._assert(params.length == nExpected, "wrong number of params for " + site + " Expected " + nExpected + " got " + params.length);
            }
        }
    }

    @Override
    public void visit(SSAInstruction.IVisitor v) {
        if (v == null) {
            throw new IllegalArgumentException("v is null");
        }
        v.visitInvoke(this);
    }

    @Override
    public int getNumberOfUses() {
        if (this.params == null) {
            Assertions._assert(this.site.getInvocationCode() == IInvokeInstruction.Dispatch.STATIC || this.site.getInvocationCode() == IInvokeInstruction.Dispatch.SPECIAL);
            Assertions._assert(this.site.getDeclaredTarget().getNumberOfParameters() == 0);
            return 0;
        }
        return this.params.length;
    }

    @Override
    public int getNumberOfParameters() {
        return this.getNumberOfUses();
    }

    @Override
    public int getNumberOfReturnValues() {
        return this.result == -1 ? 0 : 1;
    }

    @Override
    public int getReturnValue(int i) {
        assert (i == 0 && this.result != -1);
        return this.result;
    }

    @Override
    public int getUse(int j) {
        if (this.params == null) {
            Assertions._assert(false, "Invalid getUse: " + j + " , null params " + this);
        }
        if (this.params.length <= j) {
            Assertions._assert(this.params.length > j, "Invalid getUse: " + this + ", index " + j + ", params.length " + this.params.length);
        }
        return this.params[j];
    }

    @Override
    public int hashCode() {
        return this.site.hashCode() * 7529;
    }

    @Override
    public Collection<TypeReference> getExceptionTypes() {
        Collection<TypeReference> empty = Collections.emptySet();
        return this.isStatic() ? empty : Exceptions.getNullPointerException();
    }
}

