/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSALoadClassInstruction
extends SSAInstruction {
    private static final Collection<TypeReference> loadClassExceptions = Collections.singleton(TypeReference.JavaLangClassNotFoundException);
    private final int lval;
    private final TypeReference typeRef;

    public SSALoadClassInstruction(int lval, TypeReference typeRef) {
        this.lval = lval;
        this.typeRef = typeRef;
    }

    @Override
    public SSAInstruction copyForSSA(int[] defs, int[] uses) {
        if (defs != null && defs.length == 0) {
            throw new IllegalArgumentException("(defs != null) and (defs.length == 0)");
        }
        return new SSALoadClassInstruction(defs == null ? this.lval : defs[0], this.typeRef);
    }

    @Override
    public String toString(SymbolTable symbolTable) {
        return String.valueOf(this.getValueString(symbolTable, this.lval)) + " = load_class: " + this.typeRef;
    }

    @Override
    public void visit(SSAInstruction.IVisitor v) {
        if (v == null) {
            throw new IllegalArgumentException("v is null");
        }
        v.visitLoadClass(this);
    }

    @Override
    public int hashCode() {
        return this.typeRef.hashCode() * this.lval;
    }

    @Override
    public boolean isPEI() {
        return true;
    }

    @Override
    public Collection<TypeReference> getExceptionTypes() {
        return loadClassExceptions;
    }

    @Override
    public int getDef() {
        return this.lval;
    }

    @Override
    public int getDef(int i) {
        Assertions._assert(i == 0);
        return this.lval;
    }

    @Override
    public int getNumberOfDefs() {
        return 1;
    }

    @Override
    public boolean isFallThrough() {
        return true;
    }

    public TypeReference getLoadedClass() {
        return this.typeRef;
    }
}

