/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.Exceptions;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSAMonitorInstruction
extends SSAInstruction {
    private final int ref;
    private final boolean isEnter;

    SSAMonitorInstruction(int ref, boolean isEnter) {
        this.ref = ref;
        this.isEnter = isEnter;
    }

    @Override
    public SSAInstruction copyForSSA(int[] defs, int[] uses) {
        return new SSAMonitorInstruction(uses == null || uses.length == 0 ? this.ref : uses[0], this.isEnter);
    }

    @Override
    public String toString(SymbolTable symbolTable) {
        return "monitor " + this.getValueString(symbolTable, this.ref);
    }

    @Override
    public void visit(SSAInstruction.IVisitor v) {
        if (v == null) {
            throw new IllegalArgumentException("v is null");
        }
        v.visitMonitor(this);
    }

    @Override
    public int getNumberOfUses() {
        return 1;
    }

    @Override
    public int getUse(int j) {
        Assertions._assert(j == 0);
        return this.ref;
    }

    @Override
    public int hashCode() {
        return this.ref * 6173 + 4423;
    }

    @Override
    public boolean isPEI() {
        return true;
    }

    @Override
    public boolean isFallThrough() {
        return true;
    }

    @Override
    public Collection<TypeReference> getExceptionTypes() {
        return Exceptions.getNullPointerException();
    }

    public int getRef() {
        return this.ref;
    }

    public boolean isMonitorEnter() {
        return this.isEnter;
    }
}

