/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.Exceptions;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSANewInstruction
extends SSAInstruction {
    private final int result;
    private final NewSiteReference site;
    private final int[] params;

    public SSANewInstruction(int result, NewSiteReference site) throws IllegalArgumentException {
        if (site == null) {
            throw new IllegalArgumentException("site cannot be null");
        }
        Assertions._assert(!site.getDeclaredType().isArrayType() || site.getDeclaredType().getClassLoader().getLanguage() != ClassLoaderReference.Java);
        this.result = result;
        this.site = site;
        this.params = null;
    }

    public SSANewInstruction(int result, NewSiteReference site, int[] params) {
        if (params == null) {
            throw new IllegalArgumentException("params is null");
        }
        if (site == null) {
            throw new IllegalArgumentException("site is null");
        }
        Assertions._assert(site.getDeclaredType().isArrayType() || site.getDeclaredType().getClassLoader().getLanguage() != ClassLoaderReference.Java);
        this.result = result;
        this.site = site;
        this.params = new int[params.length];
        System.arraycopy(params, 0, this.params, 0, params.length);
    }

    @Override
    public SSAInstruction copyForSSA(int[] defs, int[] uses) {
        if (this.params == null) {
            return new SSANewInstruction(defs == null ? this.result : defs[0], this.site);
        }
        return new SSANewInstruction(defs == null ? this.result : defs[0], this.site, uses == null ? this.params : uses);
    }

    @Override
    public String toString(SymbolTable symbolTable) {
        return String.valueOf(this.getValueString(symbolTable, this.result)) + " = new " + this.site.getDeclaredType() + "@" + this.site.getProgramCounter() + (this.params == null ? "" : " dims: " + this.params.length);
    }

    @Override
    public void visit(SSAInstruction.IVisitor v) {
        if (v == null) {
            throw new IllegalArgumentException("v is null");
        }
        v.visitNew(this);
    }

    @Override
    public boolean hasDef() {
        return true;
    }

    @Override
    public int getDef() {
        return this.result;
    }

    @Override
    public int getDef(int i) {
        Assertions._assert(i == 0);
        return this.result;
    }

    @Override
    public int getNumberOfDefs() {
        return 1;
    }

    public TypeReference getConcreteType() {
        return this.site.getDeclaredType();
    }

    public NewSiteReference getNewSite() {
        return this.site;
    }

    @Override
    public int hashCode() {
        return this.result * 7529 + this.site.getDeclaredType().hashCode();
    }

    @Override
    public int getNumberOfUses() {
        return this.params == null ? 0 : this.params.length;
    }

    @Override
    public int getUse(int j) {
        Assertions._assert(this.params != null, "expected params but got null");
        Assertions._assert(this.params.length > j, "found too few parameters");
        return this.params[j];
    }

    @Override
    public boolean isPEI() {
        return true;
    }

    @Override
    public boolean isFallThrough() {
        return true;
    }

    @Override
    public Collection<TypeReference> getExceptionTypes() {
        return this.site.getDeclaredType().isArrayType() ? Exceptions.getNewArrayExceptions() : Exceptions.getNewScalarExceptions();
    }
}

