/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAUnaryOpInstruction;
import com.ibm.wala.ssa.SymbolTable;

public class SSAPiInstruction
extends SSAUnaryOpInstruction {
    private final SSAInstruction cause;
    private final int successorBlock;
    private final int piBlock;

    SSAPiInstruction(int result, int val, int piBlock, int s, SSAInstruction cause) {
        super(null, result, val);
        this.cause = cause;
        this.successorBlock = s;
        this.piBlock = piBlock;
    }

    public SSAInstruction copyForSSA(int[] defs, int[] uses) {
        if (defs != null && defs.length == 0) {
            throw new IllegalArgumentException("defs.length == 0");
        }
        if (uses != null && uses.length == 0) {
            throw new IllegalArgumentException("uses.length == 0");
        }
        return new SSAPiInstruction(defs == null ? this.result : defs[0], uses == null ? this.val : uses[0], this.piBlock, this.successorBlock, this.cause);
    }

    public String toString(SymbolTable symbolTable) {
        return String.valueOf(this.getValueString(symbolTable, this.result)) + " = pi " + this.getValueString(symbolTable, this.val) + " for BB" + this.successorBlock + ", cause " + this.cause;
    }

    public void visit(SSAInstruction.IVisitor v) {
        if (v == null) {
            throw new IllegalArgumentException("v is null");
        }
        v.visitPi(this);
    }

    public int getSuccessor() {
        return this.successorBlock;
    }

    public int getPiBlock() {
        return this.piBlock;
    }

    public SSAInstruction getCause() {
        return this.cause;
    }

    public int getVal() {
        return this.getUse(0);
    }
}

