/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAFieldAccessInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.util.debug.Assertions;

public class SSAPutInstruction
extends SSAFieldAccessInstruction {
    private final int val;

    public SSAPutInstruction(int ref, int val, FieldReference field) {
        super(field, ref);
        this.val = val;
    }

    public SSAPutInstruction(int val, FieldReference field) {
        super(field, -1);
        this.val = val;
    }

    public SSAInstruction copyForSSA(int[] defs, int[] uses) {
        if (this.isStatic()) {
            return new SSAPutInstruction(uses == null ? this.val : uses[0], this.getDeclaredField());
        }
        return new SSAPutInstruction(uses == null ? this.getRef() : uses[0], uses == null ? this.val : uses[1], this.getDeclaredField());
    }

    public String toString(SymbolTable symbolTable) {
        if (this.isStatic()) {
            return "putstatic " + this.getValueString(symbolTable, this.val) + " " + this.getDeclaredField();
        }
        return "putfield " + this.getValueString(symbolTable, this.getRef()) + " = " + this.getValueString(symbolTable, this.val) + " " + this.getDeclaredField();
    }

    public void visit(SSAInstruction.IVisitor v) {
        if (v == null) {
            throw new IllegalArgumentException("v is null");
        }
        v.visitPut(this);
    }

    public int getNumberOfUses() {
        return this.isStatic() ? 1 : 2;
    }

    public int getUse(int j) {
        Assertions._assert(j == 0 || !this.isStatic() && j == 1);
        return j == 0 && !this.isStatic() ? this.getRef() : this.val;
    }

    public int getVal() {
        return this.val;
    }

    public int hashCode() {
        return this.val * 9929 ^ 0x80F;
    }

    public boolean isFallThrough() {
        return true;
    }
}

