/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSAReturnInstruction
extends SSAInstruction {
    private final int result;
    private final boolean isPrimitive;

    public SSAReturnInstruction(int result, boolean isPrimitive) {
        this.result = result;
        this.isPrimitive = isPrimitive;
    }

    public SSAReturnInstruction() {
        this.result = -1;
        this.isPrimitive = false;
    }

    @Override
    public SSAInstruction copyForSSA(int[] defs, int[] uses) {
        if (this.result == -1) {
            return new SSAReturnInstruction();
        }
        return new SSAReturnInstruction(uses == null ? this.result : uses[0], this.isPrimitive);
    }

    @Override
    public String toString(SymbolTable table) {
        if (this.result == -1) {
            return "return";
        }
        return "return " + this.getValueString(table, this.result);
    }

    @Override
    public void visit(SSAInstruction.IVisitor v) {
        if (v == null) {
            throw new IllegalArgumentException("v is null");
        }
        v.visitReturn(this);
    }

    @Override
    public int getNumberOfUses() {
        return this.result == -1 ? 0 : 1;
    }

    @Override
    public int getUse(int j) {
        Assertions._assert(j == 0);
        return this.result;
    }

    public boolean returnsPrimitiveType() {
        return this.isPrimitive;
    }

    public int getResult() {
        return this.result;
    }

    public boolean returnsVoid() {
        return this.result == -1;
    }

    @Override
    public int hashCode() {
        return this.result * 8933;
    }

    @Override
    public boolean isFallThrough() {
        return false;
    }

    @Override
    public Collection<TypeReference> getExceptionTypes() {
        return Collections.emptySet();
    }
}

