/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.IntIterator;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSASwitchInstruction
extends SSAInstruction {
    private final int val;
    private final int defaultLabel;
    private final int[] casesAndLabels;

    SSASwitchInstruction(int val, int defaultLabel, int[] casesAndLabels) {
        this.val = val;
        this.defaultLabel = defaultLabel;
        this.casesAndLabels = casesAndLabels;
    }

    @Override
    public SSAInstruction copyForSSA(int[] defs, int[] uses) {
        return new SSASwitchInstruction(uses == null || uses.length == 0 ? this.val : uses[0], this.defaultLabel, this.casesAndLabels);
    }

    @Override
    public String toString(SymbolTable symbolTable) {
        StringBuffer result = new StringBuffer("switch ");
        result.append(this.getValueString(symbolTable, this.val));
        result.append(" [");
        int i = 0;
        while (i < this.casesAndLabels.length - 1) {
            result.append(this.casesAndLabels[i]);
            result.append("->");
            result.append(this.casesAndLabels[++i]);
            if (i < this.casesAndLabels.length - 2) {
                result.append(",");
            }
            ++i;
        }
        result.append("]");
        return result.toString();
    }

    @Override
    public void visit(SSAInstruction.IVisitor v) {
        if (v == null) {
            throw new IllegalArgumentException("v is null");
        }
        v.visitSwitch(this);
    }

    @Override
    public int getNumberOfUses() {
        return 1;
    }

    @Override
    public int getUse(int j) {
        Assertions._assert(j <= 1);
        return this.val;
    }

    public int getTarget(int caseValue) {
        int i = 0;
        while (i < this.casesAndLabels.length) {
            if (caseValue == this.casesAndLabels[i]) {
                return this.casesAndLabels[i + 1];
            }
            i += 2;
        }
        return this.defaultLabel;
    }

    public int getDefault() {
        return this.defaultLabel;
    }

    public int[] getCasesAndLabels() {
        return this.casesAndLabels;
    }

    public IntIterator iterateLabels() {
        return new IntIterator(){
            private int i = 0;

            public boolean hasNext() {
                return this.i < SSASwitchInstruction.this.casesAndLabels.length;
            }

            public int next() {
                int v = SSASwitchInstruction.this.casesAndLabels[this.i];
                this.i += 2;
                return v;
            }
        };
    }

    @Override
    public int hashCode() {
        return this.val * 1663 + 3499;
    }

    @Override
    public boolean isFallThrough() {
        return false;
    }

    @Override
    public Collection<TypeReference> getExceptionTypes() {
        return Collections.emptySet();
    }
}

