/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.ConstantValue;
import com.ibm.wala.ssa.PhiValue;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.Value;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.Trace;
import java.util.HashMap;

public class SymbolTable {
    private final int[] parameters;
    private final HashMap<ConstantValue, Integer> constants = HashMapFactory.make(10);
    private Value[] values = new Value[5];
    private int nextFreeValueNumber = 1;

    public SymbolTable(int numberOfParameters) {
        this.parameters = new int[numberOfParameters];
        int i = 0;
        while (i < this.parameters.length) {
            this.parameters[i] = this.getNewValueNumber();
            ++i;
        }
    }

    public int newSymbol() {
        return this.getNewValueNumber();
    }

    int findOrCreateConstant(Object o) {
        ConstantValue v = new ConstantValue(o);
        Integer result = this.constants.get(v);
        if (result == null) {
            int r = this.getNewValueNumber();
            result = new Integer(r);
            this.constants.put(v, result);
            this.values[r] = v;
        }
        return result;
    }

    public void setConstantValue(int vn, ConstantValue val) {
        this.values[vn] = val;
    }

    public void setDefaultValue(int vn, final Object defaultValue) {
        Assertions._assert(this.values[vn] == null);
        Trace.println("setting default for " + vn + " to " + defaultValue);
        this.values[vn] = new Value(){

            public boolean isStringConstant() {
                return false;
            }

            public boolean isNullConstant() {
                return false;
            }

            public int getDefaultValue(SymbolTable symtab) {
                return SymbolTable.this.findOrCreateConstant(defaultValue);
            }
        };
    }

    public int getNullConstant() {
        return this.findOrCreateConstant(null);
    }

    public int getConstant(boolean b) {
        return this.findOrCreateConstant(new Boolean(b));
    }

    public int getConstant(int i) {
        return this.findOrCreateConstant(new Integer(i));
    }

    public int getConstant(long l) {
        return this.findOrCreateConstant(new Long(l));
    }

    public int getConstant(float f) {
        return this.findOrCreateConstant(new Float(f));
    }

    public int getConstant(double d) {
        return this.findOrCreateConstant(new Double(d));
    }

    public int getConstant(String s) {
        return this.findOrCreateConstant(s);
    }

    public int getParameter(int i) throws IllegalArgumentException {
        if (this.parameters.length <= i) {
            throw new IllegalArgumentException("parameters too small for index " + i + ", length = " + this.parameters.length);
        }
        return this.parameters[i];
    }

    private void expandForNewValueNumber(int vn) {
        if (vn >= this.values.length) {
            Value[] temp = this.values;
            this.values = new Value[2 * vn];
            System.arraycopy(temp, 0, this.values, 0, temp.length);
        }
    }

    private int getNewValueNumber() {
        int result = this.nextFreeValueNumber++;
        this.expandForNewValueNumber(result);
        return result;
    }

    public void ensureSymbol(int i) {
        if (i != -1 && (i >= this.values.length || this.values[i] == null)) {
            if (this.nextFreeValueNumber <= i) {
                this.nextFreeValueNumber = i + 1;
            }
            this.expandForNewValueNumber(i);
        }
    }

    public String getValueString(int valueNumber) {
        if (valueNumber < 0 || valueNumber > this.getMaxValueNumber() || this.values[valueNumber] == null || this.values[valueNumber] instanceof PhiValue) {
            return "v" + valueNumber;
        }
        return "v" + valueNumber + ":" + this.values[valueNumber].toString();
    }

    public boolean isConstant(int v) {
        return v < this.values.length && this.values[v] instanceof ConstantValue;
    }

    public boolean isZero(int v) {
        return this.values[v] instanceof ConstantValue && ((ConstantValue)this.values[v]).isZeroConstant();
    }

    public boolean isOne(int v) {
        return this.values[v] instanceof ConstantValue && ((ConstantValue)this.values[v]).isOneConstant();
    }

    public boolean isTrue(int v) {
        return this.values[v] instanceof ConstantValue && ((ConstantValue)this.values[v]).isTrueConstant();
    }

    public boolean isZeroOrFalse(int v) {
        return this.isZero(v) || this.isFalse(v);
    }

    public boolean isOneOrTrue(int v) {
        return this.isOne(v) || this.isTrue(v);
    }

    public boolean isFalse(int v) {
        return this.values[v] instanceof ConstantValue && ((ConstantValue)this.values[v]).isFalseConstant();
    }

    public boolean isBooleanOrZeroOneConstant(int v) {
        return this.isBooleanConstant(v) || this.isZero(v) || this.isOne(v);
    }

    public boolean isBooleanConstant(int v) {
        return this.values[v] instanceof ConstantValue && ((ConstantValue)this.values[v]).getValue() instanceof Boolean;
    }

    public boolean isIntegerConstant(int v) {
        return this.values[v] instanceof ConstantValue && ((ConstantValue)this.values[v]).getValue() instanceof Integer;
    }

    public boolean isLongConstant(int v) {
        return this.values[v] instanceof ConstantValue && ((ConstantValue)this.values[v]).getValue() instanceof Long;
    }

    public boolean isFloatConstant(int v) {
        return this.values[v] instanceof ConstantValue && ((ConstantValue)this.values[v]).getValue() instanceof Float;
    }

    public boolean isDoubleConstant(int v) {
        return this.values[v] instanceof ConstantValue && ((ConstantValue)this.values[v]).getValue() instanceof Double;
    }

    public boolean isNumberConstant(int v) {
        return this.values[v] instanceof ConstantValue && ((ConstantValue)this.values[v]).getValue() instanceof Number;
    }

    public boolean isStringConstant(int v) {
        return this.values[v] instanceof ConstantValue && ((ConstantValue)this.values[v]).getValue() instanceof String;
    }

    public boolean isNullConstant(int v) {
        return this.values.length > v && this.values[v] instanceof ConstantValue && ((ConstantValue)this.values[v]).getValue() == null;
    }

    public int newPhi(int[] rhs) throws IllegalArgumentException {
        if (rhs == null) {
            throw new IllegalArgumentException("rhs is null");
        }
        int result = this.getNewValueNumber();
        SSAPhiInstruction phi = new SSAPhiInstruction(result, (int[])rhs.clone());
        this.values[result] = new PhiValue(phi);
        return result;
    }

    public PhiValue getPhiValue(int valueNumber) {
        return (PhiValue)this.values[valueNumber];
    }

    public int getMaxValueNumber() {
        return this.nextFreeValueNumber - 1;
    }

    public int[] getParameterValueNumbers() {
        return this.parameters;
    }

    public int getNumberOfParameters() {
        return this.parameters.length;
    }

    public String getStringValue(int v) throws IllegalArgumentException {
        if (!this.isStringConstant(v)) {
            throw new IllegalArgumentException("not a string constant: value number " + v);
        }
        return (String)((ConstantValue)this.values[v]).getValue();
    }

    public float getFloatValue(int v) throws IllegalArgumentException {
        if (!this.isNumberConstant(v)) {
            throw new IllegalArgumentException("value number " + v + " is not a numeric constant.");
        }
        return ((Number)((ConstantValue)this.values[v]).getValue()).floatValue();
    }

    public double getDoubleValue(int v) throws IllegalArgumentException {
        if (!this.isNumberConstant(v)) {
            throw new IllegalArgumentException("value number " + v + " is not a numeric constant.");
        }
        return ((Number)((ConstantValue)this.values[v]).getValue()).doubleValue();
    }

    public int getIntValue(int v) throws IllegalArgumentException {
        if (!this.isNumberConstant(v)) {
            throw new IllegalArgumentException("value number " + v + " is not a numeric constant.");
        }
        return ((Number)((ConstantValue)this.values[v]).getValue()).intValue();
    }

    public long getLongValue(int v) throws IllegalArgumentException {
        if (!this.isNumberConstant(v)) {
            throw new IllegalArgumentException("value number " + v + " is not a numeric constant.");
        }
        return ((Number)((ConstantValue)this.values[v]).getValue()).longValue();
    }

    public Object getConstantValue(int v) throws IllegalArgumentException {
        if (!this.isConstant(v)) {
            throw new IllegalArgumentException("value number " + v + " is not a constant.");
        }
        Object value = ((ConstantValue)this.values[v]).getValue();
        if (value == null) {
            return null;
        }
        return value;
    }

    public Value getValue(int valueNumber) {
        if (valueNumber < 1 || valueNumber >= this.values.length) {
            Assertions._assert(valueNumber >= 0, "Invalid value number " + valueNumber);
            Assertions._assert(valueNumber < this.values.length, "Invalid value number " + valueNumber);
        }
        return this.values[valueNumber];
    }

    public boolean isParameter(int valueNumber) {
        return valueNumber <= this.getNumberOfParameters();
    }
}

