/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa.analysis;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.SimpleVector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplodedControlFlowGraph
implements ControlFlowGraph<ExplodedBasicBlock> {
    private final IR ir;
    private final SimpleVector<ExplodedBasicBlock> normalNodes = new SimpleVector();
    private final Collection<ExplodedBasicBlock> allNodes = HashSetFactory.make();
    private final ExplodedBasicBlock entry;
    private final ExplodedBasicBlock exit;

    private ExplodedControlFlowGraph(IR ir) {
        assert (ir != null);
        this.ir = ir;
        this.entry = new ExplodedBasicBlock(-2, ir.getControlFlowGraph().entry());
        this.exit = new ExplodedBasicBlock(-2, ir.getControlFlowGraph().exit());
        this.createNodes();
    }

    private void createNodes() {
        this.allNodes.add(this.entry);
        this.allNodes.add(this.exit);
        for (ISSABasicBlock b : this.ir.getControlFlowGraph()) {
            int i = b.getFirstInstructionIndex();
            while (i <= b.getLastInstructionIndex()) {
                ExplodedBasicBlock bb = new ExplodedBasicBlock(i, b);
                this.normalNodes.set(i, bb);
                this.allNodes.add(bb);
                ++i;
            }
        }
    }

    public static ExplodedControlFlowGraph make(IR ir) {
        if (ir == null) {
            throw new IllegalArgumentException("ir == null");
        }
        return new ExplodedControlFlowGraph(ir);
    }

    @Override
    public ExplodedBasicBlock entry() {
        return this.entry;
    }

    @Override
    public ExplodedBasicBlock exit() {
        return this.exit;
    }

    @Override
    public ExplodedBasicBlock getBlockForInstruction(int index) {
        return this.normalNodes.get(index);
    }

    @Override
    public BitVector getCatchBlocks() {
        BitVector original = this.ir.getControlFlowGraph().getCatchBlocks();
        BitVector result = new BitVector();
        int i = 0;
        while (i <= original.max()) {
            if (original.get(i)) {
                result.set(i + 1);
            }
            ++i;
        }
        return result;
    }

    @Override
    public Collection<ExplodedBasicBlock> getExceptionalPredecessors(ExplodedBasicBlock eb) {
        assert (eb != null);
        if (eb.equals(this.entry)) {
            return Collections.emptySet();
        }
        if (eb.isExitBlock() || eb.instructionIndex == eb.original.getFirstInstructionIndex()) {
            ArrayList<ExplodedBasicBlock> result = new ArrayList<ExplodedBasicBlock>();
            for (ISSABasicBlock s : this.ir.getControlFlowGraph().getExceptionalPredecessors(eb.original)) {
                assert (this.normalNodes.get(s.getLastInstructionIndex()) != null);
                result.add(this.normalNodes.get(s.getLastInstructionIndex()));
            }
            return result;
        }
        return Collections.emptySet();
    }

    @Override
    public List<ExplodedBasicBlock> getExceptionalSuccessors(ExplodedBasicBlock eb) {
        assert (eb != null);
        if (eb.equals(this.exit)) {
            return Collections.emptyList();
        }
        if (eb.isEntryBlock() || eb.instructionIndex == eb.original.getLastInstructionIndex()) {
            ArrayList<ExplodedBasicBlock> result = new ArrayList<ExplodedBasicBlock>();
            for (ISSABasicBlock s : this.ir.getControlFlowGraph().getExceptionalSuccessors(eb.original)) {
                if (s.equals(this.ir.getControlFlowGraph().exit())) {
                    result.add(this.exit());
                    continue;
                }
                assert (this.normalNodes.get(s.getFirstInstructionIndex()) != null);
                result.add(this.normalNodes.get(s.getFirstInstructionIndex()));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public IInstruction[] getInstructions() {
        return this.ir.getInstructions();
    }

    @Override
    public IMethod getMethod() throws UnimplementedError {
        return this.ir.getMethod();
    }

    @Override
    public Collection<ExplodedBasicBlock> getNormalPredecessors(ExplodedBasicBlock eb) {
        assert (eb != null);
        if (eb.equals(this.entry)) {
            return Collections.emptySet();
        }
        if (eb.isExitBlock() || eb.instructionIndex == eb.original.getFirstInstructionIndex()) {
            ArrayList<ExplodedBasicBlock> result = new ArrayList<ExplodedBasicBlock>();
            for (ISSABasicBlock s : this.ir.getControlFlowGraph().getNormalPredecessors(eb.original)) {
                if (s.equals(this.ir.getControlFlowGraph().entry())) {
                    result.add(this.entry());
                    continue;
                }
                assert (this.normalNodes.get(s.getLastInstructionIndex()) != null);
                result.add(this.normalNodes.get(s.getLastInstructionIndex()));
            }
            return result;
        }
        assert (this.normalNodes.get(eb.instructionIndex - 1) != null);
        return Collections.singleton(this.normalNodes.get(eb.instructionIndex - 1));
    }

    @Override
    public Collection<ExplodedBasicBlock> getNormalSuccessors(ExplodedBasicBlock eb) {
        assert (eb != null);
        if (eb.equals(this.exit)) {
            return Collections.emptySet();
        }
        if (eb.isEntryBlock() || eb.instructionIndex == eb.original.getLastInstructionIndex()) {
            ArrayList<ExplodedBasicBlock> result = new ArrayList<ExplodedBasicBlock>();
            for (ISSABasicBlock s : this.ir.getControlFlowGraph().getNormalSuccessors(eb.original)) {
                if (s.equals(this.ir.getControlFlowGraph().exit())) {
                    result.add(this.exit());
                    continue;
                }
                assert (this.normalNodes.get(s.getFirstInstructionIndex()) != null);
                result.add(this.normalNodes.get(s.getFirstInstructionIndex()));
            }
            return result;
        }
        assert (this.normalNodes.get(eb.instructionIndex + 1) != null);
        return Collections.singleton(this.normalNodes.get(eb.instructionIndex + 1));
    }

    @Override
    public int getProgramCounter(int index) throws UnimplementedError {
        return this.ir.getControlFlowGraph().getProgramCounter(index);
    }

    @Override
    public void removeNodeAndEdges(ExplodedBasicBlock N) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addNode(ExplodedBasicBlock n) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsNode(ExplodedBasicBlock N) {
        return this.allNodes.contains(N);
    }

    @Override
    public int getNumberOfNodes() {
        return this.allNodes.size();
    }

    @Override
    public Iterator<ExplodedBasicBlock> iterator() {
        return this.allNodes.iterator();
    }

    @Override
    public void removeNode(ExplodedBasicBlock n) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addEdge(ExplodedBasicBlock src, ExplodedBasicBlock dst) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getPredNodeCount(ExplodedBasicBlock b) throws IllegalArgumentException {
        if (b == null) {
            throw new IllegalArgumentException("b == null");
        }
        if (b.isEntryBlock()) {
            return 0;
        }
        if (b.equals(this.exit) || b.instructionIndex == b.original.getFirstInstructionIndex()) {
            return this.ir.getControlFlowGraph().getPredNodeCount(b.original);
        }
        return 1;
    }

    @Override
    public Iterator<? extends ExplodedBasicBlock> getPredNodes(ExplodedBasicBlock b) throws IllegalArgumentException {
        if (b == null) {
            throw new IllegalArgumentException("b == null");
        }
        if (b.isEntryBlock()) {
            return EmptyIterator.instance();
        }
        if (b.equals(this.exit) || b.instructionIndex == b.original.getFirstInstructionIndex()) {
            ArrayList<ExplodedBasicBlock> result = new ArrayList<ExplodedBasicBlock>();
            Iterator<ISSABasicBlock> it = this.ir.getControlFlowGraph().getPredNodes(b.original);
            while (it.hasNext()) {
                ISSABasicBlock s = it.next();
                if (s.isEntryBlock()) {
                    result.add(this.entry);
                    continue;
                }
                assert (this.normalNodes.get(s.getLastInstructionIndex()) != null);
                result.add(this.normalNodes.get(s.getLastInstructionIndex()));
            }
            return result.iterator();
        }
        assert (this.normalNodes.get(b.instructionIndex - 1) != null);
        return NonNullSingletonIterator.make(this.normalNodes.get(b.instructionIndex - 1));
    }

    @Override
    public int getSuccNodeCount(ExplodedBasicBlock N) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return 0;
    }

    @Override
    public Iterator<? extends ExplodedBasicBlock> getSuccNodes(ExplodedBasicBlock b) {
        assert (b != null);
        if (b.equals(this.exit)) {
            return EmptyIterator.instance();
        }
        if (b.isEntryBlock() || b.instructionIndex == b.original.getLastInstructionIndex()) {
            ArrayList<ExplodedBasicBlock> result = new ArrayList<ExplodedBasicBlock>();
            Iterator<ISSABasicBlock> it = this.ir.getControlFlowGraph().getSuccNodes(b.original);
            while (it.hasNext()) {
                ISSABasicBlock s = it.next();
                if (s.equals(this.ir.getControlFlowGraph().exit())) {
                    result.add(this.exit());
                    continue;
                }
                assert (this.normalNodes.get(s.getFirstInstructionIndex()) != null);
                result.add(this.normalNodes.get(s.getFirstInstructionIndex()));
            }
            return result.iterator();
        }
        assert (this.normalNodes.get(b.instructionIndex + 1) != null);
        return NonNullSingletonIterator.make(this.normalNodes.get(b.instructionIndex + 1));
    }

    @Override
    public boolean hasEdge(ExplodedBasicBlock src, ExplodedBasicBlock dst) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return false;
    }

    @Override
    public void removeAllIncidentEdges(ExplodedBasicBlock node) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeEdge(ExplodedBasicBlock src, ExplodedBasicBlock dst) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeIncomingEdges(ExplodedBasicBlock node) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeOutgoingEdges(ExplodedBasicBlock node) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxNumber() {
        return this.getNumberOfNodes() - 1;
    }

    @Override
    public ExplodedBasicBlock getNode(int number) {
        if (number == 0) {
            return this.entry();
        }
        if (number == this.getNumberOfNodes() - 1) {
            return this.exit();
        }
        return this.normalNodes.get(number - 1);
    }

    @Override
    public int getNumber(ExplodedBasicBlock n) throws IllegalArgumentException {
        if (n == null) {
            throw new IllegalArgumentException("n == null");
        }
        return n.getNumber();
    }

    @Override
    public Iterator<ExplodedBasicBlock> iterateNodes(IntSet s) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public IntSet getPredNodeNumbers(ExplodedBasicBlock node) {
        MutableSparseIntSet result = MutableSparseIntSet.makeEmpty();
        Iterator<? extends ExplodedBasicBlock> it = this.getPredNodes(node);
        while (it.hasNext()) {
            result.add(this.getNumber(it.next()));
        }
        return result;
    }

    @Override
    public IntSet getSuccNodeNumbers(ExplodedBasicBlock node) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    public String toString() {
        StringBuffer s = new StringBuffer("");
        for (ExplodedBasicBlock bb : this) {
            s.append("BB").append(this.getNumber(bb)).append("\n");
            Iterator<? extends ExplodedBasicBlock> succNodes = this.getSuccNodes(bb);
            while (succNodes.hasNext()) {
                s.append("    -> BB").append(this.getNumber(succNodes.next())).append("\n");
            }
        }
        return s.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ExplodedBasicBlock
    implements ISSABasicBlock {
        private final int instructionIndex;
        private final ISSABasicBlock original;

        public ExplodedBasicBlock(int instructionIndex, ISSABasicBlock original) {
            this.instructionIndex = instructionIndex;
            this.original = original;
            assert (original != null);
        }

        @Override
        public Iterator<TypeReference> getCaughtExceptionTypes() {
            if (this.original instanceof SSACFG.ExceptionHandlerBasicBlock) {
                SSACFG.ExceptionHandlerBasicBlock eb = (SSACFG.ExceptionHandlerBasicBlock)this.original;
                return eb.getCaughtExceptionTypes();
            }
            return EmptyIterator.instance();
        }

        @Override
        public int getFirstInstructionIndex() {
            return this.instructionIndex;
        }

        @Override
        public int getLastInstructionIndex() {
            return this.instructionIndex;
        }

        @Override
        public IMethod getMethod() {
            return ExplodedControlFlowGraph.this.getMethod();
        }

        @Override
        public int getNumber() {
            if (this.isEntryBlock()) {
                return 0;
            }
            if (this.isExitBlock()) {
                return ExplodedControlFlowGraph.this.getNumberOfNodes() - 1;
            }
            return this.instructionIndex + 1;
        }

        @Override
        public boolean isCatchBlock() {
            return this.original.isCatchBlock() && this.instructionIndex == this.original.getFirstInstructionIndex();
        }

        public SSAGetCaughtExceptionInstruction getCatchInstruction() {
            assert (this.original instanceof SSACFG.ExceptionHandlerBasicBlock);
            SSACFG.ExceptionHandlerBasicBlock e = (SSACFG.ExceptionHandlerBasicBlock)this.original;
            return e.getCatchInstruction();
        }

        @Override
        public boolean isEntryBlock() {
            return this.original.isEntryBlock();
        }

        @Override
        public boolean isExitBlock() {
            return this.original.isExitBlock();
        }

        @Override
        public int getGraphNodeId() {
            Assertions.UNREACHABLE();
            return 0;
        }

        @Override
        public void setGraphNodeId(int number) {
            Assertions.UNREACHABLE();
        }

        @Override
        public Iterator<IInstruction> iterator() {
            if (this.isEntryBlock() || this.isExitBlock() || this.getInstruction() == null) {
                return EmptyIterator.instance();
            }
            return NonNullSingletonIterator.make(this.getInstruction());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.instructionIndex;
            result = 31 * result + (this.original == null ? 0 : this.original.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExplodedBasicBlock other = (ExplodedBasicBlock)obj;
            if (this.instructionIndex != other.instructionIndex) {
                return false;
            }
            return !(this.original == null ? other.original != null : !this.original.equals(other.original));
        }

        public SSAInstruction getInstruction() {
            if (this.isEntryBlock() || this.isExitBlock()) {
                return null;
            }
            return ExplodedControlFlowGraph.this.ir.getInstructions()[this.instructionIndex];
        }

        @Override
        public SSAInstruction getLastInstruction() {
            if (this.getLastInstructionIndex() < 0) {
                return null;
            }
            return ExplodedControlFlowGraph.this.ir.getInstructions()[this.getLastInstructionIndex()];
        }

        @Override
        public Iterator<SSAPhiInstruction> iteratePhis() {
            if (this.isEntryBlock() || this.isExitBlock() || this.instructionIndex != this.original.getFirstInstructionIndex()) {
                return EmptyIterator.instance();
            }
            return this.original.iteratePhis();
        }

        @Override
        public Iterator<SSAPiInstruction> iteratePis() {
            if (this.isEntryBlock() || this.isExitBlock() || this.instructionIndex != this.original.getLastInstructionIndex()) {
                return EmptyIterator.instance();
            }
            return this.original.iteratePis();
        }

        public String toString() {
            return "ExplodedBlock[" + this.getNumber() + "](original:" + this.original.toString() + ")";
        }
    }
}

