/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.types;

import com.ibm.wala.util.Atom;

public class ClassLoaderReference {
    public static final Atom Java = Atom.findOrCreateUnicodeAtom("Java");
    public static final ClassLoaderReference Primordial = new ClassLoaderReference(Atom.findOrCreateUnicodeAtom("Primordial"), Java);
    public static final ClassLoaderReference Extension = new ClassLoaderReference(Atom.findOrCreateUnicodeAtom("Extension"), Java);
    public static final ClassLoaderReference Application = new ClassLoaderReference(Atom.findOrCreateUnicodeAtom("Application"), Java);
    private final Atom name;
    private final Atom language;
    private ClassLoaderReference parent;

    public ClassLoaderReference(Atom name, Atom language) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.name = name;
        this.language = language;
    }

    public Atom getName() {
        return this.name;
    }

    public Atom getLanguage() {
        return this.language;
    }

    public ClassLoaderReference getParent() {
        return this.parent;
    }

    public void setParent(ClassLoaderReference parent) {
        this.parent = parent;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        ClassLoaderReference o = (ClassLoaderReference)obj;
        return this.name.equals(o.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.name.toString());
        result.append(" classloader");
        result.append("\n");
        return result.toString();
    }
}

