/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.types;

import com.ibm.wala.util.Atom;
import com.ibm.wala.util.ImmutableByteArray;
import com.ibm.wala.util.StringStuff;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.debug.Assertions;
import java.io.UTFDataFormatException;
import java.util.Map;

public final class TypeName {
    private static final Map<TypeNameKey, TypeName> map = HashMapFactory.make();
    private final TypeNameKey key;

    private static TypeName findOrCreate(TypeNameKey t) {
        TypeName result = map.get(t);
        if (result == null) {
            result = new TypeName(t);
            map.put(t, result);
        }
        return result;
    }

    public static TypeName findOrCreate(ImmutableByteArray name, int start, int length) throws IllegalArgumentException {
        Atom className = Atom.findOrCreate(StringStuff.parseForClass(name, start, length));
        ImmutableByteArray p = StringStuff.parseForPackage(name, start, length);
        Atom packageName = p == null ? null : Atom.findOrCreate(p);
        short dim = StringStuff.parseForArrayDimensionality(name, start, length);
        boolean innermostPrimitive = StringStuff.classIsPrimitive(name, start, length);
        if (innermostPrimitive && dim == 0) {
            dim = -1;
        }
        TypeNameKey t = new TypeNameKey(packageName, className, dim, innermostPrimitive);
        return TypeName.findOrCreate(t);
    }

    public static TypeName findOrCreate(ImmutableByteArray name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        return TypeName.findOrCreate(name, 0, name.length());
    }

    public static TypeName findOrCreate(String name) throws IllegalArgumentException {
        ImmutableByteArray b = ImmutableByteArray.make(name);
        return TypeName.findOrCreate(b);
    }

    public static TypeName findOrCreateClass(Atom packageName, Atom className) {
        Assertions._assert(packageName != null);
        TypeNameKey T = new TypeNameKey(packageName, className, 0, false);
        return TypeName.findOrCreate(T);
    }

    private static TypeName findOrCreate(Atom packageName, Atom className, short dim, boolean innermostPrimitive) {
        TypeNameKey T = new TypeNameKey(packageName, className, dim, innermostPrimitive);
        return TypeName.findOrCreate(T);
    }

    private TypeName(TypeNameKey key) {
        this.key = key;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return this.key.toString();
    }

    public String toUnicodeString() {
        return this.key.toUnicodeString();
    }

    public static TypeName string2TypeName(String s) throws IllegalArgumentException {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        byte[] val = s.getBytes();
        return TypeName.findOrCreate(new ImmutableByteArray(val));
    }

    public static TypeName findOrCreateClassName(String packageName, String className) {
        Atom p = Atom.findOrCreateUnicodeAtom(packageName);
        Atom c = Atom.findOrCreateUnicodeAtom(className);
        return TypeName.findOrCreateClass(p, c);
    }

    public TypeName parseForArrayElementName() {
        short newDim = (short)(this.key.dim - 1);
        if (newDim == 0 && this.key.innermostPrimitive) {
            newDim = -1;
        }
        return TypeName.findOrCreate(this.key.packageName, this.key.className, newDim, this.key.innermostPrimitive);
    }

    public TypeName getArrayTypeForElementType() {
        short newDim = (short)(this.key.dim + 1);
        if (newDim == 0) {
            newDim = 1;
        }
        return TypeName.findOrCreate(this.key.packageName, this.key.className, newDim, this.key.innermostPrimitive);
    }

    public final int getDimensionality() {
        return this.key.dim;
    }

    public final boolean isClassType() {
        return this.key.dim == 0;
    }

    public final boolean isArrayType() {
        return this.key.dim > 0;
    }

    public final boolean isPrimitiveType() {
        return this.key.dim == -1;
    }

    public final TypeName getInnermostElementType() {
        short newDim = this.key.innermostPrimitive ? (short)-1 : 0;
        return TypeName.findOrCreate(this.key.packageName, this.key.className, newDim, this.key.innermostPrimitive);
    }

    public Atom getPackage() {
        return this.key.packageName;
    }

    public Atom getClassName() {
        return this.key.className;
    }

    private static final class TypeNameKey {
        private final Atom packageName;
        private final Atom className;
        private final short dim;
        private final boolean innermostPrimitive;

        private TypeNameKey(Atom packageName, Atom className, short dim, boolean innermostPrimitive) {
            this.packageName = packageName;
            this.className = className;
            this.dim = dim;
            this.innermostPrimitive = innermostPrimitive;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TypeNameKey) {
                TypeNameKey other = (TypeNameKey)obj;
                return this.className == other.className && this.packageName == other.packageName && this.dim == other.dim && this.innermostPrimitive == other.innermostPrimitive;
            }
            return false;
        }

        public int hashCode() {
            int result = this.className.hashCode() * 5009 + this.dim * 5011 + (this.innermostPrimitive ? 5021 : 5023);
            if (this.packageName != null) {
                result += this.packageName.hashCode();
            }
            return result;
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            short i = 0;
            while (i < this.dim) {
                result.append("[");
                i = (short)(i + 1);
            }
            if (!this.innermostPrimitive) {
                result.append("L");
            }
            if (this.packageName != null) {
                result.append(this.packageName.toString());
                result.append("/");
            }
            result.append(this.className.toString());
            return result.toString();
        }

        public String toUnicodeString() {
            try {
                StringBuffer result = new StringBuffer();
                short i = 0;
                while (i < this.dim) {
                    result.append("[");
                    i = (short)(i + 1);
                }
                if (!this.innermostPrimitive) {
                    result.append("L");
                }
                if (this.packageName != null) {
                    result.append(this.packageName.toUnicodeString());
                    result.append("/");
                }
                result.append(this.className.toUnicodeString());
                return result.toString();
            }
            catch (UTFDataFormatException e) {
                e.printStackTrace();
                Assertions.UNREACHABLE();
                return null;
            }
        }
    }
}

