/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeBT.ConstantInstruction;
import com.ibm.wala.shrikeBT.Constants;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.InvokeInstruction;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MemberReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.warnings.Warning;
import com.ibm.wala.util.warnings.Warnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Exceptions
implements Constants {
    private static final Collection<TypeReference> arrayAccessExceptions = Collections.unmodifiableCollection((Collection)Arrays.asList(TypeReference.JavaLangNullPointerException, TypeReference.JavaLangArrayIndexOutOfBoundsException));
    private static final Collection<TypeReference> aaStoreExceptions = Collections.unmodifiableCollection((Collection)Arrays.asList(TypeReference.JavaLangNullPointerException, TypeReference.JavaLangArrayIndexOutOfBoundsException, TypeReference.JavaLangArrayStoreException));
    private static final Collection<TypeReference> newScalarExceptions = Collections.unmodifiableCollection((Collection)Arrays.asList(TypeReference.JavaLangExceptionInInitializerError, TypeReference.JavaLangOutOfMemoryError));
    private static final Collection<TypeReference> newArrayExceptions = Collections.unmodifiableCollection((Collection)Arrays.asList(TypeReference.JavaLangOutOfMemoryError, TypeReference.JavaLangNegativeArraySizeException));
    private static final Collection<TypeReference> nullPointerException = Collections.singleton(TypeReference.JavaLangNullPointerException);
    private static final Collection<TypeReference> arithmeticException = Collections.singleton(TypeReference.JavaLangArithmeticException);
    private static final Collection<TypeReference> classCastException = Collections.singleton(TypeReference.JavaLangClassCastException);
    private static final Collection<TypeReference> classNotFoundException = Collections.singleton(TypeReference.JavaLangClassNotFoundException);
    private static final Collection<TypeReference> runtimeExceptions = Collections.unmodifiableCollection((Collection)Arrays.asList(TypeReference.JavaLangArithmeticException, TypeReference.JavaLangArrayStoreException, TypeReference.JavaLangClassCastException, TypeReference.JavaLangArrayIndexOutOfBoundsException, TypeReference.JavaLangNegativeArraySizeException, TypeReference.JavaLangNullPointerException));

    public static Collection<TypeReference> getExceptionTypes(ClassLoaderReference loader, Instruction pei, IClassHierarchy cha) {
        if (pei == null) {
            throw new IllegalArgumentException("pei is null");
        }
        switch (pei.getOpcode()) {
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                InvokeInstruction call = (InvokeInstruction)pei;
                Collection<TypeReference> result = null;
                try {
                    result = Exceptions.inferInvokeExceptions(MethodReference.findOrCreate(loader, call.getClassType(), call.getMethodName(), call.getMethodSignature()), cha);
                }
                catch (InvalidClassFileException e) {
                    e.printStackTrace();
                    Assertions.UNREACHABLE();
                }
                return result;
            }
            case 191: {
                Assertions.UNREACHABLE("This class does not have the smarts to infer exception types for athrow");
                return null;
            }
        }
        return Exceptions.getIndependentExceptionTypes(pei);
    }

    public static Collection<TypeReference> inferInvokeExceptions(MethodReference target, IClassHierarchy cha) throws InvalidClassFileException {
        if (cha == null) {
            throw new IllegalArgumentException("cha is null");
        }
        if (target == null) {
            throw new IllegalArgumentException("target is null");
        }
        ArrayList<TypeReference> set = new ArrayList<TypeReference>(runtimeExceptions);
        set.addAll(cha.getJavaLangErrorTypes());
        IClass klass = cha.lookupClass(target.getDeclaringClass());
        if (klass == null) {
            Warnings.add(MethodResolutionFailure.moderate(target));
        }
        if (klass != null) {
            IMethod M = klass.getMethod(target.getSelector());
            if (M == null) {
                Warnings.add(MethodResolutionFailure.severe(target));
            } else {
                TypeReference[] exceptionTypes = M.getDeclaredExceptions();
                if (exceptionTypes != null) {
                    set.addAll((Collection<TypeReference>)Arrays.asList(exceptionTypes));
                }
            }
        }
        return set;
    }

    public static Collection<TypeReference> getIndependentExceptionTypes(Instruction pei) {
        if (pei == null) {
            throw new IllegalArgumentException("pei is null");
        }
        switch (pei.getOpcode()) {
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 86: {
                return Exceptions.getArrayAccessExceptions();
            }
            case 83: {
                return Exceptions.getAaStoreExceptions();
            }
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 185: {
                return Exceptions.getNullPointerException();
            }
            case 108: 
            case 109: 
            case 112: 
            case 113: {
                return Exceptions.getArithmeticException();
            }
            case 187: {
                return newScalarExceptions;
            }
            case 188: 
            case 189: 
            case 197: {
                return newArrayExceptions;
            }
            case 190: {
                return Exceptions.getNullPointerException();
            }
            case 191: {
                return Exceptions.getNullPointerException();
            }
            case 192: {
                return Exceptions.getClassCastException();
            }
            case 194: 
            case 195: {
                return Exceptions.getNullPointerException();
            }
            case 19: {
                if (((ConstantInstruction)pei).getType().equals("Ljava/lang/Class;")) {
                    return Exceptions.getClassNotFoundException();
                }
                return null;
            }
        }
        return null;
    }

    public static boolean isPEI(Instruction s) {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        switch (s.getOpcode()) {
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 108: 
            case 109: 
            case 112: 
            case 113: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 194: 
            case 195: 
            case 197: {
                return true;
            }
            case 19: {
                return ((ConstantInstruction)s).getType().equals("Ljava/lang/Class;");
            }
        }
        return false;
    }

    public static Collection<TypeReference> getAaStoreExceptions() {
        return aaStoreExceptions;
    }

    public static Collection<TypeReference> getArithmeticException() {
        return arithmeticException;
    }

    public static Collection<TypeReference> getArrayAccessExceptions() {
        return arrayAccessExceptions;
    }

    public static Collection<TypeReference> getClassCastException() {
        return classCastException;
    }

    public static Collection<TypeReference> getClassNotFoundException() {
        return classNotFoundException;
    }

    public static Collection<TypeReference> getNewArrayExceptions() {
        return newArrayExceptions;
    }

    public static Collection<TypeReference> getNewScalarExceptions() {
        return newScalarExceptions;
    }

    public static Collection<TypeReference> getNullPointerException() {
        return nullPointerException;
    }

    public static Collection<TypeReference> getRuntimeExceptions() {
        return runtimeExceptions;
    }

    private static class MethodResolutionFailure
    extends Warning {
        final MemberReference method;

        MethodResolutionFailure(byte code, MemberReference method) {
            super(code);
            this.method = method;
        }

        public String getMsg() {
            return String.valueOf(this.getClass().toString()) + " : " + this.method;
        }

        public static MethodResolutionFailure moderate(MemberReference method) {
            return new MethodResolutionFailure(1, method);
        }

        public static MethodResolutionFailure severe(MemberReference method) {
            return new MethodResolutionFailure(2, method);
        }
    }
}

