/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.ShrikeCTMethod;
import com.ibm.wala.classLoader.ShrikeClass;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import java.lang.ref.WeakReference;

public class ReferenceCleanser {
    private static final float OCCUPANCY_TRIGGER = 0.5f;
    private static WeakReference<IClassHierarchy> cha;
    private static WeakReference<AnalysisCache> cache;

    public static void registerClassHierarchy(IClassHierarchy cha) {
        ReferenceCleanser.cha = new WeakReference<IClassHierarchy>(cha);
    }

    private static IClassHierarchy getClassHierarchy() {
        IClassHierarchy result = null;
        if (cha != null) {
            result = (IClassHierarchy)cha.get();
        }
        return result;
    }

    public static void registerCache(AnalysisCache cache) {
        ReferenceCleanser.cache = new WeakReference<AnalysisCache>(cache);
    }

    private static AnalysisCache getAnalysisCache() {
        AnalysisCache result = null;
        if (cache != null) {
            result = (AnalysisCache)cache.get();
        }
        return result;
    }

    public static void clearSoftCaches() {
        IClassHierarchy cha;
        float occupancy = 1.0f - (float)Runtime.getRuntime().freeMemory() / (float)Runtime.getRuntime().totalMemory();
        if (occupancy < 0.5f) {
            return;
        }
        if (ReferenceCleanser.getAnalysisCache() != null) {
            ReferenceCleanser.getAnalysisCache().getSSACache().wipe();
            ReferenceCleanser.getAnalysisCache().getCFGCache().wipe();
        }
        if ((cha = ReferenceCleanser.getClassHierarchy()) != null) {
            for (IClass klass : cha) {
                if (klass instanceof ShrikeClass) {
                    ShrikeClass c = (ShrikeClass)klass;
                    c.clearSoftCaches();
                    continue;
                }
                for (IMethod m : klass.getDeclaredMethods()) {
                    if (!(m instanceof ShrikeCTMethod)) continue;
                    ((ShrikeCTMethod)m).clearCaches();
                }
            }
        }
    }
}

