/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util;

import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.util.CacheReference;
import com.ibm.wala.util.debug.Assertions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ShrikeClassReaderHandle {
    private static final boolean DEBUG = false;
    private final ModuleEntry entry;
    private Object reader;
    private int hydrateCount = 0;

    public ShrikeClassReaderHandle(ModuleEntry entry) {
        this.entry = entry;
    }

    public ClassReader get() throws InvalidClassFileException {
        ClassReader result = (ClassReader)CacheReference.get(this.reader);
        if (result == null) {
            ++this.hydrateCount;
            ByteArrayOutputStream S = new ByteArrayOutputStream();
            try {
                InputStream s = this.entry.getInputStream();
                this.readBytes(s, S);
                s.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                Assertions.UNREACHABLE();
            }
            result = new ClassReader(S.toByteArray());
            this.reader = CacheReference.make(result);
        }
        return result;
    }

    private void readBytes(InputStream is, ByteArrayOutputStream bytes) throws IOException {
        int n = 0;
        byte[] buffer = new byte[1024];
        while (n > -1) {
            n = is.read(buffer, 0, 1024);
            if (n <= -1) continue;
            bytes.write(buffer, 0, n);
        }
    }

    public String getFileName() {
        return this.entry.getName();
    }

    public void clear() {
        this.reader = null;
    }

    public ModuleEntry getModuleEntry() {
        return this.entry;
    }
}

