/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util;

import com.ibm.wala.shrikeBT.BytecodeConstants;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.shrikeBT.InvokeInstruction;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.ImmutableByteArray;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.debug.Assertions;
import java.util.HashMap;

public class ShrikeUtil
implements BytecodeConstants {
    private static final HashMap<String, TypeReference> primitiveMap = HashMapFactory.make(10);

    static {
        primitiveMap.put("I", TypeReference.Int);
        primitiveMap.put("J", TypeReference.Long);
        primitiveMap.put("S", TypeReference.Short);
        primitiveMap.put("B", TypeReference.Byte);
        primitiveMap.put("C", TypeReference.Char);
        primitiveMap.put("D", TypeReference.Double);
        primitiveMap.put("F", TypeReference.Float);
        primitiveMap.put("Z", TypeReference.Boolean);
        primitiveMap.put("V", TypeReference.Void);
        primitiveMap.put("L;", TypeReference.Null);
    }

    public static IInvokeInstruction.Dispatch getInvocationCode(InvokeInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException("instruction is null");
        }
        switch (instruction.getInvocationMode()) {
            case 184: {
                return IInvokeInstruction.Dispatch.STATIC;
            }
            case 182: {
                return IInvokeInstruction.Dispatch.VIRTUAL;
            }
            case 183: {
                return IInvokeInstruction.Dispatch.SPECIAL;
            }
            case 185: {
                return IInvokeInstruction.Dispatch.INTERFACE;
            }
        }
        Assertions.UNREACHABLE();
        return null;
    }

    public static TypeReference makeTypeReference(ClassLoaderReference loader, String type) throws IllegalArgumentException {
        Assertions._assert(type != null);
        TypeReference p = primitiveMap.get(type);
        if (p != null) {
            return p;
        }
        ImmutableByteArray b = ImmutableByteArray.make(type);
        TypeName T = null;
        T = b.get(0) != 91 ? TypeName.findOrCreate(b, 0, b.length() - 1) : (b.get(b.length() - 1) == 59 ? TypeName.findOrCreate(b, 0, b.length() - 1) : TypeName.findOrCreate(b));
        return TypeReference.findOrCreate(loader, T);
    }
}

