/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util;

import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.Atom;
import com.ibm.wala.util.ImmutableByteArray;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.debug.Assertions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class StringStuff {
    private static final HashMap<String, String> primitiveClassNames = HashMapFactory.make(10);

    static {
        primitiveClassNames.put("int", "I");
        primitiveClassNames.put("long", "J");
        primitiveClassNames.put("short", "S");
        primitiveClassNames.put("byte", "B");
        primitiveClassNames.put("char", "C");
        primitiveClassNames.put("double", "D");
        primitiveClassNames.put("float", "F");
        primitiveClassNames.put("boolean", "Z");
        primitiveClassNames.put("void", "V");
    }

    public static void padWithSpaces(StringBuffer b, int length) {
        if (b == null) {
            throw new IllegalArgumentException("b is null");
        }
        if (b.length() < length) {
            int i = b.length();
            while (i < length) {
                b.append(" ");
                ++i;
            }
        }
    }

    public static String deployment2CanonicalTypeString(String dString) {
        if (dString == null) {
            throw new IllegalArgumentException("dString is null");
        }
        int arrayIndex = (dString = dString.replace('.', '/')).indexOf("[]");
        if (arrayIndex > -1) {
            String baseType = dString.substring(0, arrayIndex);
            int dim = (dString.length() - arrayIndex) / 2;
            baseType = StringStuff.deployment2CanonicalTypeString(baseType);
            StringBuffer result = new StringBuffer("[");
            int i = 1;
            while (i < dim) {
                result.append("[");
                ++i;
            }
            result.append(baseType);
            return result.toString();
        }
        if (primitiveClassNames.get(dString) != null) {
            return primitiveClassNames.get(dString);
        }
        return "L" + dString;
    }

    public static String deployment2CanonicalDescriptorTypeString(String dString) {
        if (dString == null) {
            throw new IllegalArgumentException("dString is null");
        }
        int arrayIndex = (dString = dString.replace('.', '/')).indexOf("[]");
        if (arrayIndex > -1) {
            String baseType = dString.substring(0, arrayIndex);
            int dim = (dString.length() - arrayIndex) / 2;
            baseType = StringStuff.deployment2CanonicalDescriptorTypeString(baseType);
            StringBuffer result = new StringBuffer("[");
            int i = 1;
            while (i < dim) {
                result.append("[");
                ++i;
            }
            result.append(baseType);
            return result.toString();
        }
        if (primitiveClassNames.get(dString) != null) {
            return primitiveClassNames.get(dString);
        }
        return "L" + dString + ";";
    }

    public static final TypeName parseForReturnTypeName(String desc) throws IllegalArgumentException {
        return StringStuff.parseForReturnTypeName(ImmutableByteArray.make(desc));
    }

    public static final TypeName parseForReturnTypeName(ImmutableByteArray b) throws IllegalArgumentException {
        if (b == null) {
            throw new IllegalArgumentException("b is null");
        }
        if (b.length() <= 2) {
            throw new IllegalArgumentException("invalid descriptor: " + b);
        }
        if (b.get(0) != 40) {
            throw new IllegalArgumentException("invalid descriptor: " + b);
        }
        int i = 0;
        while (b.get(i++) != 41) {
        }
        switch (b.get(i)) {
            case 86: {
                return TypeReference.Void.getName();
            }
            case 90: {
                return TypeReference.Boolean.getName();
            }
            case 66: {
                return TypeReference.Byte.getName();
            }
            case 83: {
                return TypeReference.Short.getName();
            }
            case 73: {
                return TypeReference.Int.getName();
            }
            case 74: {
                return TypeReference.Long.getName();
            }
            case 70: {
                return TypeReference.Float.getName();
            }
            case 68: {
                return TypeReference.Double.getName();
            }
            case 67: {
                return TypeReference.Char.getName();
            }
            case 76: 
            case 91: {
                if (b.get(b.length() - 1) == 59) {
                    return TypeName.findOrCreate(b, i, b.length() - i - 1);
                }
                return TypeName.findOrCreate(b, i, b.length() - i);
            }
        }
        throw new IllegalArgumentException("unexpected type in descriptor " + b);
    }

    public static final TypeName[] parseForParameterNames(String descriptor) throws IllegalArgumentException {
        return StringStuff.parseForParameterNames(ImmutableByteArray.make(descriptor));
    }

    public static final TypeName[] parseForParameterNames(ImmutableByteArray b) throws IllegalArgumentException {
        if (b == null) {
            throw new IllegalArgumentException("b is null");
        }
        if (b.length() <= 2) {
            throw new IllegalArgumentException("invalid descriptor: " + b);
        }
        if (b.get(0) != 40) {
            throw new IllegalArgumentException("invalid descriptor: " + b);
        }
        ArrayList<TypeName> sigs = new ArrayList<TypeName>(10);
        int i = 1;
        block14: while (true) {
            switch (b.get(i++)) {
                case 86: {
                    sigs.add(TypeReference.VoidName);
                    continue block14;
                }
                case 90: {
                    sigs.add(TypeReference.BooleanName);
                    continue block14;
                }
                case 66: {
                    sigs.add(TypeReference.ByteName);
                    continue block14;
                }
                case 83: {
                    sigs.add(TypeReference.ShortName);
                    continue block14;
                }
                case 73: {
                    sigs.add(TypeReference.IntName);
                    continue block14;
                }
                case 74: {
                    sigs.add(TypeReference.LongName);
                    continue block14;
                }
                case 70: {
                    sigs.add(TypeReference.FloatName);
                    continue block14;
                }
                case 68: {
                    sigs.add(TypeReference.DoubleName);
                    continue block14;
                }
                case 67: {
                    sigs.add(TypeReference.CharName);
                    continue block14;
                }
                case 76: {
                    int off = i - 1;
                    while (b.get(i++) != 59) {
                    }
                    sigs.add(TypeName.findOrCreate(b, off, i - off - 1));
                    continue block14;
                }
                case 91: {
                    int off = i - 1;
                    while (b.get(i) == 91) {
                        ++i;
                    }
                    TypeName T = null;
                    if (b.get(i++) == 76) {
                        while (b.get(i++) != 59) {
                        }
                        T = TypeName.findOrCreate(b, off, i - off - 1);
                    } else {
                        T = TypeName.findOrCreate(b, off, i - off);
                    }
                    sigs.add(T);
                    continue block14;
                }
                case 41: {
                    int size = sigs.size();
                    if (size == 0) {
                        return null;
                    }
                    Iterator it = sigs.iterator();
                    TypeName[] result = new TypeName[size];
                    int j = 0;
                    while (j < size) {
                        result[j] = (TypeName)it.next();
                        ++j;
                    }
                    return result;
                }
            }
            Assertions._assert(false, "bad descriptor " + b);
        }
    }

    public static ImmutableByteArray parseForPackage(ImmutableByteArray name, int start, int length) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name == null");
        }
        int lastSlash = -1;
        int i = start;
        while (i < start + length) {
            if (name.b[i] == 47) {
                lastSlash = i;
            }
            ++i;
        }
        if (lastSlash == -1) {
            return null;
        }
        short dim = StringStuff.parseForArrayDimensionality(name, start, length);
        return new ImmutableByteArray(name.b, start + 1 + dim, lastSlash - start - 1 - dim);
    }

    public static ImmutableByteArray parseForPackage(ImmutableByteArray name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        return StringStuff.parseForPackage(name, 0, name.length());
    }

    public static ImmutableByteArray parseForClass(ImmutableByteArray name, int start, int length) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("invalid class name: zero length");
        }
        if (StringStuff.parseForPackage(name, start, length) == null) {
            while (name.b[start] == 91) {
                ++start;
                --length;
            }
            if (name.b[start] == 76) {
                ++start;
                --length;
            }
            return new ImmutableByteArray(name.b, start, length);
        }
        int lastSlash = 0;
        int i = start;
        while (i < start + length) {
            if (name.b[i] == 47) {
                lastSlash = i;
            }
            ++i;
        }
        int L = length - (lastSlash - start + 1);
        return new ImmutableByteArray(name.b, lastSlash + 1, L);
    }

    public static ImmutableByteArray parseForClass(ImmutableByteArray name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        return StringStuff.parseForClass(name, 0, name.length());
    }

    public static short parseForArrayDimensionality(ImmutableByteArray b, int start, int length) throws IllegalArgumentException, IllegalArgumentException {
        if (b == null) {
            throw new IllegalArgumentException("b == null");
        }
        int i = start;
        while (i < start + length) {
            if (b.b[i] != 91) {
                return (short)(i - start);
            }
            ++i;
        }
        throw new IllegalArgumentException("ill-formed array descriptor " + b);
    }

    public static ImmutableByteArray parseForInnermostArrayElementDescriptor(ImmutableByteArray b, int start, int length) {
        if (b == null) {
            throw new IllegalArgumentException("b is null");
        }
        int i = start;
        while (i < start + length) {
            if (b.b[i] != 91) break;
            ++i;
        }
        return new ImmutableByteArray(b.b, i, length - (i - start));
    }

    public static ImmutableByteArray parseForInnermostArrayElementDescriptor(Atom a) {
        if (a == null) {
            throw new IllegalArgumentException("a is null");
        }
        ImmutableByteArray b = new ImmutableByteArray(a.val);
        return StringStuff.parseForInnermostArrayElementDescriptor(b, 0, b.length());
    }

    /*
     * Unable to fully structure code
     */
    public static boolean classIsPrimitive(ImmutableByteArray name, int start, int length) throws IllegalArgumentException {
        if (name != null) ** GOTO lbl5
        throw new IllegalArgumentException("name is null");
lbl-1000:
        // 1 sources

        {
            ++start;
            --length;
lbl5:
            // 2 sources

            ** while (length > 0 && name.b[start] == 91)
        }
lbl6:
        // 1 sources

        if (start >= name.b.length) {
            throw new IllegalArgumentException("ill-formed type name: " + name);
        }
        return name.b[start] != 76;
    }

    public static MethodReference makeMethodReference(String methodSig) throws IllegalArgumentException {
        if (methodSig == null) {
            throw new IllegalArgumentException("methodSig is null");
        }
        if (methodSig.lastIndexOf(46) < 0) {
            throw new IllegalArgumentException("ill-formed sig " + methodSig);
        }
        String type = methodSig.substring(0, methodSig.lastIndexOf(46));
        type = StringStuff.deployment2CanonicalTypeString(type);
        TypeReference t = TypeReference.findOrCreate(ClassLoaderReference.Application, type);
        String methodName = methodSig.substring(methodSig.lastIndexOf(46) + 1, methodSig.indexOf(40));
        String desc = methodSig.substring(methodSig.indexOf(40));
        return MethodReference.findOrCreate(t, methodName, desc);
    }

    public static String jvmToReadableType(String jvmType) throws IllegalArgumentException {
        if (jvmType == null) {
            throw new IllegalArgumentException("jvmType is null");
        }
        StringBuffer readable = new StringBuffer();
        int numberOfDimensions = 0;
        if (jvmType.length() == 0) {
            throw new IllegalArgumentException("ill-formed type : " + jvmType);
        }
        char prefix = jvmType.charAt(0);
        while (prefix == '[') {
            prefix = jvmType.charAt(++numberOfDimensions);
        }
        if (prefix == 'V') {
            readable.append("void");
        } else if (prefix == 'B') {
            readable.append("byte");
        } else if (prefix == 'C') {
            readable.append("char");
        } else if (prefix == 'D') {
            readable.append("double");
        } else if (prefix == 'F') {
            readable.append("float");
        } else if (prefix == 'I') {
            readable.append("int");
        } else if (prefix == 'J') {
            readable.append("long");
        } else if (prefix == 'S') {
            readable.append("short");
        } else if (prefix == 'Z') {
            readable.append("boolean");
        } else if (prefix == 'L') {
            readable.append(jvmType.substring(numberOfDimensions + 1, jvmType.length()));
            readable = new StringBuffer(StringStuff.slashToDot(readable.toString()));
            readable = new StringBuffer(StringStuff.dollarToDot(readable.toString()));
        }
        int i = 0;
        while (i < numberOfDimensions) {
            readable.append("[]");
            ++i;
        }
        return readable.toString();
    }

    public static String jvmToBinaryName(String jvmType) throws IllegalArgumentException {
        if (jvmType == null) {
            throw new IllegalArgumentException("jvmType is null");
        }
        StringBuffer readable = new StringBuffer();
        int numberOfDimensions = 0;
        if (jvmType.length() == 0) {
            throw new IllegalArgumentException("ill-formed type : " + jvmType);
        }
        char prefix = jvmType.charAt(0);
        while (prefix == '[') {
            prefix = jvmType.charAt(++numberOfDimensions);
        }
        if (prefix == 'V') {
            readable.append("void");
        } else if (prefix == 'B') {
            readable.append("byte");
        } else if (prefix == 'C') {
            readable.append("char");
        } else if (prefix == 'D') {
            readable.append("double");
        } else if (prefix == 'F') {
            readable.append("float");
        } else if (prefix == 'I') {
            readable.append("int");
        } else if (prefix == 'J') {
            readable.append("long");
        } else if (prefix == 'S') {
            readable.append("short");
        } else if (prefix == 'Z') {
            readable.append("boolean");
        } else if (prefix == 'L') {
            readable.append(jvmType.substring(numberOfDimensions + 1, jvmType.length()));
            readable = new StringBuffer(StringStuff.slashToDot(readable.toString()));
        }
        int i = 0;
        while (i < numberOfDimensions) {
            readable.append("[]");
            ++i;
        }
        return readable.toString();
    }

    public static String slashToDot(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        StringBuffer dotForm = new StringBuffer(path);
        int i = 0;
        while (i < dotForm.length()) {
            if (dotForm.charAt(i) == '/') {
                dotForm.setCharAt(i, '.');
            }
            ++i;
        }
        return dotForm.toString();
    }

    public static String dollarToDot(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        StringBuffer dotForm = new StringBuffer(path);
        int i = 0;
        while (i < dotForm.length()) {
            if (dotForm.charAt(i) == '$') {
                dotForm.setCharAt(i, '.');
            }
            ++i;
        }
        return dotForm.toString();
    }

    public static String dotToDollar(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        StringBuffer dotForm = new StringBuffer(path);
        int i = 0;
        while (i < dotForm.length()) {
            if (dotForm.charAt(i) == '.') {
                dotForm.setCharAt(i, '$');
            }
            ++i;
        }
        return dotForm.toString();
    }
}

