/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.collections;

import java.util.NoSuchElementException;

public abstract class Heap {
    private int numberOfElements = 0;
    private Object[] backingStore;

    protected abstract boolean compareElements(Object var1, Object var2);

    public int size() {
        return this.numberOfElements;
    }

    public Heap(int initialCapacity) {
        this.backingStore = new Object[initialCapacity];
    }

    public final boolean isEmpty() {
        return this.numberOfElements == 0;
    }

    public void insert(Object elt) {
        this.ensureCapacity(this.numberOfElements + 1);
        this.bubbleUp(elt, this.numberOfElements);
        ++this.numberOfElements;
    }

    public Object take() throws NoSuchElementException {
        if (this.numberOfElements == 0) {
            throw new NoSuchElementException();
        }
        Object result = this.backingStore[0];
        this.removeElement(0);
        return result;
    }

    private static int heapParent(int index) {
        return (index - 1) / 2;
    }

    private static int heapLeftChild(int index) {
        return index * 2 + 1;
    }

    private static int heapRightChild(int index) {
        return index * 2 + 2;
    }

    private final void ensureCapacity(int min) {
        if (this.backingStore.length < min) {
            Object[] newStore = new Object[2 * min];
            System.arraycopy(this.backingStore, 0, newStore, 0, this.backingStore.length);
            this.backingStore = newStore;
        }
    }

    private final void removeElement(int index) {
        int leftIndex;
        int ne = this.numberOfElements;
        Object[] bs = this.backingStore;
        while ((leftIndex = Heap.heapLeftChild(index)) < ne) {
            int rightIndex = Heap.heapRightChild(index);
            if (rightIndex < ne) {
                Object leftObject = bs[leftIndex];
                Object rightObject = bs[rightIndex];
                if (this.compareElements(leftObject, rightObject)) {
                    bs[index] = leftObject;
                    index = leftIndex;
                    continue;
                }
                bs[index] = rightObject;
                index = rightIndex;
                continue;
            }
            bs[index] = bs[leftIndex];
            index = leftIndex;
        }
        --this.numberOfElements;
        ne = this.numberOfElements;
        if (index != ne) {
            this.bubbleUp(bs[ne], index);
        }
    }

    private final void bubbleUp(Object elt, int index) {
        Object[] bs = this.backingStore;
        while (true) {
            if (index == 0) {
                bs[index] = elt;
                return;
            }
            int hpIndex = Heap.heapParent(index);
            Object parent = bs[hpIndex];
            if (this.compareElements(parent, elt)) {
                bs[index] = elt;
                return;
            }
            bs[index] = parent;
            index = hpIndex;
        }
    }
}

